/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.widgets.OntologyDropdown;
import org.eaglei.model.EIEntity;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SharedClassChooser;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

public class FilterPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    protected HorizontalPanel subTypeFilter;
    @UiField
    protected Label subTypeLabel;
    @UiField
    protected ListBox statusFilter;
    @UiField
    protected ListBox resourceTypeFilter;
    @UiField
    protected ListBox labFilter;
    @UiField
    protected Label statusLabel;
    @UiField
    protected Label labLabel;
    @UiField
    protected Label resourceTypeLabel;
    @UiField
    protected Label filterLabel;
    @UiField
    protected Label totalResources;
    @UiField
    protected RadioButton ownedByMe;
    @UiField
    protected RadioButton all;
    @UiField
    protected Button goButton;
    SharedClassChooser<OntologyDropdown> classChooser;
    private boolean isTopLevel = false;
    private static final GWTLogger log = GWTLogger.getLogger((String)"FilterPanel");
    private final String genericOption = "All";

    protected FilterPanel() {
    }

    public FilterPanel(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity) {
        this.init(filterTypeEntity, filterWorkflowEntity, filterLabEntity);
        this.initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterLabEntity, false);
    }

    public FilterPanel(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity, boolean strictFilterByOwner) {
        this.init(filterTypeEntity, filterWorkflowEntity, filterLabEntity);
        this.initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterLabEntity, strictFilterByOwner);
    }

    private void init(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.filterLabel.setVisible(true);
        if (filterTypeEntity != null && !filterTypeEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            this.initSubTypeFilter(filterTypeEntity);
        } else {
            this.isTopLevel = true;
            this.resourceTypeFilter.addItem("All");
            this.subTypeFilter.setVisible(false);
            this.subTypeLabel.setVisible(false);
            this.disable((FocusWidget)this.resourceTypeFilter);
        }
        this.initWorkflowFilter(filterWorkflowEntity);
        this.initLabFilter(filterLabEntity);
        this.initGoButton();
    }

    public void disable() {
        this.disable((FocusWidget)this.resourceTypeFilter);
        this.disable((FocusWidget)this.labFilter);
        this.disable((FocusWidget)this.statusFilter);
        this.disable((FocusWidget)this.goButton);
    }

    private void disable(FocusWidget filter) {
        filter.setEnabled(false);
        filter.setStyleName("btnDisabled");
    }

    public void setCount(int numberOfResources) {
        this.totalResources.setText("(" + numberOfResources + ") instances found");
        this.totalResources.setVisible(true);
    }

    private void initOwnerFilter(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity, boolean strictFilterByOwner) {
        this.all.setValue(Boolean.valueOf(!strictFilterByOwner));
        this.ownedByMe.setValue(Boolean.valueOf(strictFilterByOwner));
        1 clickHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.ownedByMe.addClickHandler((ClickHandler)clickHandler);
        this.all.addClickHandler((ClickHandler)clickHandler);
    }

    private void initGoButton() {
        this.goButton.setVisible(true);
        this.goButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initWorkflowFilter(EIEntity filterWorkflowEntity) {
        this.statusFilter.setVisible(true);
        this.statusLabel.setVisible(true);
        this.statusFilter.addItem("All");
        for (EIEntity entity : WorkFlowConstants.WORKFLOW_ENTITY_LIST) {
            this.statusFilter.addItem(entity.getLabel(), entity.getURI().toString());
            if (!entity.equals((Object)filterWorkflowEntity)) continue;
            this.statusFilter.setSelectedIndex(this.statusFilter.getItemCount() - 1);
        }
    }

    private void initLabFilter(EIEntity filterLabEntity) {
        this.labFilter.setVisible(true);
        this.labLabel.setVisible(true);
        if (ApplicationState.getInstance().getTypeEntity().equals((Object)EagleIEntityConstants.EI_LAB_ENTITY)) {
            this.labFilter.addItem("All");
            this.disable((FocusWidget)this.labFilter);
            return;
        }
        if (!EIEntity.NULL_ENTITY.equals((Object)filterLabEntity)) {
            this.labFilter.addItem(filterLabEntity.getLabel(), filterLabEntity.getURI().toString());
        } else {
            this.labFilter.addItem("All");
        }
        if (!EIEntity.NULL_ENTITY.equals((Object)ApplicationState.getInstance().getLabEntity())) {
            this.disable((FocusWidget)this.labFilter);
        } else {
            this.labFilter.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void initSubTypeFilter(EIEntity filterTypeEntity) {
        this.resourceTypeFilter.setVisible(false);
        this.resourceTypeLabel.setVisible(false);
        this.classChooser = new SharedClassChooser((OntologyDropdownBase)new OntologyDropdown());
        this.classChooser.setTextBoxStyle("formText");
        this.subTypeFilter.add((Widget)this.classChooser);
        this.subTypeLabel.setVisible(false);
        this.subTypeFilter.setVisible(true);
        ClientModelManager.INSTANCE.getClass(ApplicationState.getInstance().getTypeUri(), (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isGenericOption(String label) {
        return "All".equals(label);
    }

    static /* synthetic */ boolean access$000(FilterPanel x0) {
        return x0.isTopLevel;
    }

    static /* synthetic */ boolean access$100(FilterPanel x0, String x1) {
        return x0.isGenericOption(x1);
    }

    static /* synthetic */ GWTLogger access$200() {
        return log;
    }
}

