/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.LabCache;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.datatools.client.ui.widgets.LeftListRowWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public class LeftListPanel
extends VerticalPanel
implements ClientRepositoryToolsManager.SessionListener,
ApplicationStateChangeListener,
LabCache.LabCacheListener {
    private static final String PANEL_SELECTED = "panelSelected";
    private static final String PANEL_NOT_SELECTED = "panelNotSelected";
    private static final int TYPE_COLUMN = 0;
    private static final int ALL_TYPES_ROW = 1;
    private boolean signedIn = false;
    private List<EIClass> resourceTypes;
    private EIClass personType;
    private EIClass organizationType;
    private final Map<EIEntity, String> definitions = new HashMap();
    private FlexTable labsTable = new FlexTable();
    private FlexTable resourcesTable = new FlexTable();
    private FlexTable peopleTable = new FlexTable();
    private final Label labNameLabel = new Label("");
    private final Anchor switchLabsLink = new Anchor();
    private ListBox labsList = new ListBox();
    private Label resourcesLink = new Label();
    private Label peopleAndOrganizationLink = new Label();
    private final FlowPanel labsPanel = new FlowPanel();
    private final FlowPanel resourcesPanel = new FlowPanel();
    private final FlowPanel peoplePanel = new FlowPanel();
    private final LabCache labCache;
    private static final GWTLogger log = GWTLogger.getLogger((String)"LeftListPanel");

    public LeftListPanel(LabCache labCache) {
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
        ApplicationState.getInstance().addApplicationStateListener((ApplicationStateChangeListener)this);
        this.labCache = labCache;
        labCache.addLabLoadListener((LabCache.LabCacheListener)this);
        this.signedIn = ApplicationState.getInstance().hasUser();
        if (this.signedIn) {
            this.getResourceTypes();
        }
    }

    public void onApplicationStateChange() {
        this.drawFromApplicationState();
    }

    private void drawFromApplicationState() {
        if (!ApplicationState.getInstance().hasUser() && !this.signedIn) {
            this.labsTable.setVisible(false);
            this.resourcesTable.setVisible(false);
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.workbench) {
            this.setVisible(false);
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.labs || ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.edit && ApplicationState.getInstance().hasLabType() || ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter && ApplicationState.getInstance().hasLabType()) {
            this.setVisible(false);
            this.labNameLabel.setText("");
            this.labsTable.setVisible(true);
            this.labsPanel.setVisible(true);
            this.resourcesTable.setVisible(false);
            this.resourcesPanel.setVisible(false);
            this.peoplePanel.setVisible(false);
            this.peopleTable.setVisible(false);
            this.selectType(this.labsTable);
            this.unselectAll(this.resourcesTable);
            this.unselectAll(this.peopleTable);
            this.resourcesPanel.setStyleName(PANEL_NOT_SELECTED);
        } else if (ApplicationState.getInstance().hasLab()) {
            this.setVisible(true);
            this.labNameLabel.setText(ApplicationState.getInstance().getLabEntity().getLabel());
            this.labsTable.setVisible(true);
            this.labsPanel.setVisible(true);
            this.resourcesTable.setVisible(false);
            this.resourcesPanel.setVisible(false);
            this.peoplePanel.setVisible(false);
            this.peopleTable.setVisible(false);
            if (!ApplicationState.getInstance().hasType() || ApplicationState.getInstance().hasLabType()) {
                this.unselectAll(this.labsTable);
                if (QueryTokenObject.Mode.isResourcesList((QueryTokenObject.Mode)ApplicationState.getInstance().getMode())) {
                    this.labsTable.getRowFormatter().setStyleName(1, PANEL_SELECTED);
                }
            } else {
                this.selectType(this.labsTable);
            }
            this.unselectAll(this.resourcesTable);
            this.unselectAll(this.peopleTable);
            this.resourcesPanel.setStyleName(PANEL_NOT_SELECTED);
            this.peoplePanel.setStyleName(PANEL_NOT_SELECTED);
        } else {
            this.setVisible(true);
            this.labNameLabel.setText("[No lab selected]");
            this.labsTable.setVisible(false);
            this.labsPanel.setVisible(false);
            this.resourcesTable.setVisible(true);
            this.resourcesPanel.setVisible(true);
            this.peoplePanel.setVisible(true);
            this.peopleTable.setVisible(true);
            this.selectType(this.resourcesTable);
            this.selectType(this.peopleTable);
            this.unselectAll(this.labsTable);
        }
    }

    private boolean shouldShowResourcesList() {
        return ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources || ApplicationState.getInstance().hasType();
    }

    private void getResourceTypes() {
        ClientRepositoryToolsManager.INSTANCE.getTopClassesAnotatedByDataModelCreate((ClientRepositoryToolsManager.TopLevelClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getTypeDefinitions() {
        log.debug("Left panel getting definitions");
        ClientModelManager.INSTANCE.getClassDefinitions(this.resourceTypes, (ClientModelManager.ClassDefinitionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPanel() {
        log.debug("left list panel creating sub-panel; logged in? " + this.signedIn);
        this.resourcesLink.setText("Browse Resources");
        this.resourcesLink.setStyleName("leftListHeader");
        this.switchLabsLink.setHTML("switch labs");
        this.switchLabsLink.setStyleName("gwt_add_item");
        this.switchLabsLink.addStyleName("liveLink");
        this.setStyleName("leftPanel");
        this.peopleAndOrganizationLink.setText("Browse People and Organizations");
        this.peopleAndOrganizationLink.setStyleName("leftListHeader");
        if (this.signedIn) {
            this.createLabsSection();
            this.add((Widget)this.labsPanel);
            this.add((Widget)this.labsTable);
            this.addAllTypesOption(this.labsTable);
            this.populateTypeTable(this.labsTable);
            this.resourcesPanel.add((Widget)this.resourcesLink);
            this.peoplePanel.add((Widget)this.peopleAndOrganizationLink);
            this.add((Widget)this.resourcesPanel);
            this.add((Widget)this.resourcesTable);
            this.add((Widget)this.peoplePanel);
            this.add((Widget)this.peopleTable);
            this.addAllTypesOption(this.resourcesTable);
            this.populateTypeTable(this.resourcesTable);
            this.populatePersonAndOrganizationTable(this.peopleTable);
            this.resourcesTable.setVisible(this.shouldShowResourcesList());
            this.peopleTable.setVisible(this.shouldShowResourcesList());
            this.drawFromApplicationState();
        }
    }

    private void createLabsSection() {
        String labName = ApplicationState.getInstance().hasLab() ? ApplicationState.getInstance().getLabEntity().getLabel() : "";
        this.labNameLabel.setText(labName);
        this.labNameLabel.setStyleName("labSelected");
        this.labNameLabel.addStyleName("liveLink");
        this.labNameLabel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.labsPanel.add((Widget)this.labNameLabel);
        this.labsPanel.add((Widget)this.switchLabsLink);
        this.labsList.setVisible(false);
        if (this.labCache.isLoading()) {
            this.labsList.addItem("loading...");
        } else {
            this.populateLabsList();
        }
        this.labsPanel.add((Widget)this.labsList);
        this.switchLabsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void populateLabsList() {
        if (this.labCache.isLoading()) {
            return;
        }
        this.labsList.setStyleName("leftListDropdown");
        this.labsList.clear();
        this.labsList.addItem("select a lab");
        for (EIEntity lab : this.labCache.getLabEntities()) {
            this.labsList.addItem(lab.getLabel(), lab.getURI().toString());
        }
        this.labsList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void populateTypeTable(FlexTable table) {
        for (EIClass eiClass : this.resourceTypes) {
            table.setWidget(table.getRowCount(), 0, (Widget)new LeftListRowWidget(eiClass, (String)this.definitions.get(eiClass.getEntity()), table == this.labsTable));
        }
    }

    private void populatePersonAndOrganizationTable(FlexTable table) {
        table.setWidget(this.peopleTable.getRowCount(), 0, (Widget)new LeftListRowWidget(DatatoolsUIConstants.personEntity, DatatoolsUIConstants.personEntity.getLabel(), false));
        table.setWidget(this.peopleTable.getRowCount(), 0, (Widget)new LeftListRowWidget(DatatoolsUIConstants.organizationEntity, DatatoolsUIConstants.organizationEntity.getLabel(), false));
    }

    private void addAllTypesOption(FlexTable typesTable) {
        EIEntity allTypesEntity = EIEntity.create((EIURI)EIURI.NULL_EIURI, (String)"All Resource Types");
        typesTable.setWidget(1, 0, (Widget)new LeftListRowWidget(allTypesEntity, "", false));
    }

    private void selectType(FlexTable typesTable) {
        if (typesTable == this.labsTable || typesTable == this.resourcesTable) {
            if (!ApplicationState.getInstance().hasType() && QueryTokenObject.Mode.isResourcesList((QueryTokenObject.Mode)ApplicationState.getInstance().getMode()) && ApplicationState.getInstance().getMode() != QueryTokenObject.Mode.resources) {
                typesTable.getRowFormatter().setStyleName(1, PANEL_SELECTED);
            } else {
                typesTable.getRowFormatter().setStyleName(1, PANEL_NOT_SELECTED);
            }
        }
        int start = typesTable == this.labsTable || typesTable == this.resourcesTable ? 2 : 0;
        EIEntity typeEntity = ApplicationState.getInstance().getTypeEntity();
        for (int i = start; i < typesTable.getRowCount(); ++i) {
            LeftListRowWidget rowWidget = (LeftListRowWidget)typesTable.getWidget(i, 0);
            if (ApplicationState.getInstance().hasType() && rowWidget.getEntity().equals((Object)typeEntity)) {
                typesTable.getRowFormatter().setStyleName(i, PANEL_SELECTED);
                continue;
            }
            typesTable.getRowFormatter().setStyleName(i, PANEL_NOT_SELECTED);
        }
    }

    private void unselectAll(FlexTable typesTable) {
        for (int i = 0; i < typesTable.getRowCount(); ++i) {
            typesTable.getRowFormatter().setStyleName(i, PANEL_NOT_SELECTED);
        }
    }

    public void onLogOut() {
        this.signedIn = false;
        this.labsTable = new FlexTable();
        this.labsPanel.clear();
        this.resourcesTable = new FlexTable();
        this.resourcesPanel.clear();
        this.labsList = new ListBox();
        this.resourcesLink = new Label();
        this.peopleAndOrganizationLink = new Label();
        this.peoplePanel.clear();
        this.peopleTable = new FlexTable();
        this.clear();
    }

    public void onLogIn(String username, String userUri) {
        this.signedIn = true;
        if (this.resourceTypes != null && this.resourceTypes.size() > 0) {
            this.createPanel();
        } else {
            log.debug("left list panel logging in: about to get resource types");
            this.getResourceTypes();
        }
    }

    public void onLabsLoaded() {
        this.populateLabsList();
    }

    static /* synthetic */ GWTLogger access$000() {
        return log;
    }

    static /* synthetic */ List access$102(LeftListPanel x0, List x1) {
        x0.resourceTypes = x1;
        return x0.resourceTypes;
    }

    static /* synthetic */ void access$200(LeftListPanel x0) {
        x0.getTypeDefinitions();
    }

    static /* synthetic */ Map access$300(LeftListPanel x0) {
        return x0.definitions;
    }

    static /* synthetic */ void access$400(LeftListPanel x0) {
        x0.createPanel();
    }

    static /* synthetic */ ListBox access$500(LeftListPanel x0) {
        return x0.labsList;
    }

    static /* synthetic */ LabCache access$600(LeftListPanel x0) {
        return x0.labCache;
    }
}

