/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

public class EIResourceListWidget
extends EditWidget {
    private static final String CREATE_NEW_VALUE = "<create new>";
    private static final String NO_VALUE = "<none>";
    private final ListBox instances = new ListBox();
    private final EIClass range;
    private final boolean shouldHaveLabel;
    private static GWTLogger log = GWTLogger.getLogger((String)"EIResourceListWidget");

    public EIResourceListWidget(EIInstance instance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, boolean shouldShowLabel) {
        super(instance, propertyEntity, propertyDefinition, isRequired);
        this.range = range;
        if (selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY) {
            this.oldValue = selectedEntity.getURI().toString();
            if (selectedEntity.getLabel().equals("") || selectedEntity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) {
                selectedEntity.setLabel(selectedEntity.getURI().toString());
            }
        }
        this.shouldHaveLabel = shouldShowLabel;
        if (!this.shouldHaveLabel) {
            this.widgetPanel.remove((Widget)this.label);
        }
        this.setup();
        this.intializeInstances();
    }

    private void intializeInstances() {
        this.instances.setStyleName("formDropdown");
        this.addDefaultInstanceValues();
        if (this.range.equals((Object)EIClass.NULL_CLASS)) {
            log.info("skipping get instances");
            if (this.hasOldValue()) {
                this.instances.removeItem(this.instances.getItemCount() - 1);
                String probablyDeletedLabel = "[non-standard link] " + this.getOldStringValue();
                this.instances.addItem(probablyDeletedLabel, this.getOldStringValue());
                this.instances.setSelectedIndex(this.instances.getItemCount() - 1);
            }
        } else {
            try {
                AuthSearchRequest request = new AuthSearchRequest();
                request.setType(this.range.getEntity().getURI());
                request.setPaginated(false);
                ClientRepositoryToolsManager.INSTANCE.listResources(request, SortByProperties.label, false, (ClientRepositoryToolsManager.EIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        this.instances.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addDefaultInstanceValues() {
        this.instances.addItem(NO_VALUE, null);
        this.instances.addItem(CREATE_NEW_VALUE, null);
        this.instances.addItem("...loading...", null);
    }

    private void doOnChange(EIInstance instance, EIClass range, EIEntity propertyEntity, String propertyValue, ListBox subClassList) {
        if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(NO_VALUE)) {
            this.removeValue();
        } else if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(CREATE_NEW_VALUE)) {
            int currentPosition = this.widgetPanel.getAbsoluteTop();
            PopupPanel dialog = WidgetUtils.createDialog((EIInstance)instance, (EIClass)range, (EIEntity)propertyEntity, (EIURI)EIURI.create((String)this.oldValue), (int)currentPosition, (WidgetUtils.InstanceSaveCallback)new /* Unavailable Anonymous Inner Class!! */);
            dialog.show();
            Style style = dialog.getElement().getStyle();
            style.clearOverflow();
        } else {
            if (this.hasOldValue()) {
                this.eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create((String)this.oldValue), WidgetUtils.getSelectedEntity((ListBox)subClassList));
            } else {
                this.eiInstance.addObjectProperty(propertyEntity, WidgetUtils.getSelectedEntity((ListBox)subClassList));
            }
            this.updateOldValue(WidgetUtils.getSelectedUri((ListBox)subClassList));
        }
    }

    private void setup() {
        this.instances.setName(this.propertyEntity.getURI().toString() + "_instances");
        this.widgetPanel.add((Widget)this.instances);
    }

    private String formatInstanceForListBox(EIInstanceMinimal valueInstance) {
        return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">" + (!valueInstance.getLab().equals((Object)EIEntity.NULL_ENTITY) ? ", " + valueInstance.getLab().getLabel() : "");
    }

    private String formatInstanceForListBox(EIInstance valueInstance) {
        return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">";
    }

    public EditWidget duplicateBlank() {
        return new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.range, (EIEntity)null, true);
    }

    protected void removeValue() {
        if (this.hasOldValue()) {
            this.eiInstance.replaceObjectPropertyValue(this.propertyEntity, this.getOldEIURIValue(), null);
        }
    }

    public void disable() {
        this.instances.setEnabled(false);
    }

    static /* synthetic */ ListBox access$000(EIResourceListWidget x0) {
        return x0.instances;
    }

    static /* synthetic */ String access$100(EIResourceListWidget x0, EIInstanceMinimal x1) {
        return x0.formatInstanceForListBox(x1);
    }

    static /* synthetic */ EIClass access$200(EIResourceListWidget x0) {
        return x0.range;
    }

    static /* synthetic */ void access$300(EIResourceListWidget x0, EIInstance x1, EIClass x2, EIEntity x3, String x4, ListBox x5) {
        x0.doOnChange(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ String access$400(EIResourceListWidget x0, EIInstance x1) {
        return x0.formatInstanceForListBox(x1);
    }

    static /* synthetic */ GWTLogger access$500() {
        return log;
    }
}

