package org.eaglei.datatools.client.logging;

import java.util.logging.Logger;
import java.util.logging.Level;

public class GWTLogger {

	private final Logger innerLogger;
	
	public static GWTLogger getLogger(String name) {
		return new GWTLogger(name);
	}
	
	private GWTLogger(String name) {
		innerLogger = Logger.getLogger(name);
	}
	
	public void debug(String message) {
		innerLogger.log( Level.FINER, message);
	}
	
	public void info(String message) {
		innerLogger.log( Level.FINE, message);
	}
	
	public void warn(String message) {
		innerLogger.log( Level.WARNING, message);
	}
	
	public void error(String message) {
		innerLogger.log( Level.SEVERE, message);
	}
}
