package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.MinimalEIInstancesCallback;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

import com.google.gwt.user.client.Window;

public class MainController implements ApplicationStateChangeListener {

	public static final String DATATOOLS_FILTER = "DatatoolsFilter";
	public static final String DATATOOLS_CONTROLS = "DatatoolsControls";

	private static final GWTLogger log = GWTLogger.getLogger( "MainController" );

	public MainController() {
		ApplicationState.getInstance().addApplicationStateListener( this );
		onApplicationStateChange();
	}

	@Override
	public void onApplicationStateChange() {
		if ( !ApplicationState.getInstance().hasUser() ) {
			log.info( "no user!" );
			Datatools.clearDataPanel();
			return;
		}
		
		if ( Mode.isResourcesList( ApplicationState.getInstance().getMode() ) ) {
			drawResourcesListMode();
		} else if ( ApplicationState.getInstance().getMode() == Mode.workbench ) {
			drawWorkbench();
		} else if ( ApplicationState.getInstance().getMode() == Mode.view ) {
			drawView();
		} else if ( ApplicationState.getInstance().getMode() == Mode.edit ) {
			drawEdit();
		} 
	}

	private void drawResourcesListMode() {
		/*if ( ApplicationState.getInstance().getMode() == Mode.resources ) {
			log.debug( "showing empty grid" );
			Datatools.clearDataPanel();
			Datatools.showData( new EIResourcesGrid() );
		} else */ 
		if ( ApplicationState.getInstance().getMode() == Mode.references ) {
			if ( ApplicationState.getInstance().hasInstance() ) {
				log.info( "showing references to " + ApplicationState.getInstance().getInstanceEntity().getLabel() );

				drawGrid();
			} else {
				log.warn( "trying to display references mode with no instance!" );
				Window.alert( "Trying to display references without a referrent!" ); // TODO: move to messages if we keep this
			}
		} else {
			drawGrid();
		}
	}

	protected void drawWorkbench() {
		Datatools.showWorkbench();
	}

	protected void drawGrid() {
		Datatools.clearDataPanel();
		if ( ApplicationState.getInstance().getMode() == Mode.resources ) {
			Datatools.showData( new EIResourcesGrid() );
			return;
		}

		if ( applicationShouldShowEmptyGrid() ) {
			Datatools.showData( new EIResourcesGrid() );
			return;
		}

		EIURI typeUri, WFStateUri, labUri;
		if ( ApplicationState.getInstance().getMode() == Mode.filter ) {
			typeUri = ApplicationState.getInstance().getFilterTypeUri();
			WFStateUri = ApplicationState.getInstance().getFilterWorkflowUri();
			labUri = ApplicationState.getInstance().getFilterLabUri();
			log.debug( "setting parameters for filter query: " + typeUri + ", " + WFStateUri + ", " + labUri );
		} else {
			typeUri = ApplicationState.getInstance().getTypeUri();
			WFStateUri = EIURI.NULL_EIURI;
			labUri = ApplicationState.getInstance().getLabUri();
			log.debug( "setting parameters for unfiltered query: " + typeUri + ", " + WFStateUri + ", " + labUri );
		}
		Datatools.showGlasspane();
		try {
			final AuthSearchRequest request = new AuthSearchRequest();
			if (ApplicationState.getInstance().isPaginated()) {
				request.setPaginated( true );
				request.setStartIndex( ApplicationState.getInstance().getOffset() );
				request.setMaxResults( ApplicationState.getInstance().getLimit() );
			} else {
				request.setPaginated( false );
			}
			if ( ApplicationState.getInstance().getMode() == Mode.references ) {
				ClientRepositoryToolsManager.INSTANCE.listReferencingResources( ApplicationState.getInstance().getInstanceUri(), request, SortByProperties.getOrderBy( ApplicationState.getInstance().getSortBy() ), ApplicationState.getInstance()
						.isStrictlyFilteredByOwner(), getDisplayCallback() );
			} else {
				request.setType( typeUri );
				request.setWFState( WFStateUri );
				request.setLab( labUri );
				final boolean requestStubs = ApplicationState.getInstance().getMode() == Mode.stubs;
				if ( requestStubs ) {
					log.debug( "requesting stubs; type is " + typeUri + "; instance is " + ApplicationState.getInstance().getInstanceUri() );
				}
				ClientRepositoryToolsManager.INSTANCE.listResources( request, SortByProperties.getOrderBy( ApplicationState.getInstance().getSortBy() ), ApplicationState.getInstance().isStrictlyFilteredByOwner(), requestStubs, getDisplayCallback() );
			}
		} catch (final Exception e) {
			log.error( e.getMessage() );
		}
	}

	private boolean applicationShouldShowEmptyGrid() {
		return false;
	}

	private MinimalEIInstancesCallback getDisplayCallback() {
		return new MinimalEIInstancesCallback() {
			@Override
			public void onSuccess(final List<EIInstanceMinimal> result) {
				Datatools.hideGlasspane();
				final EIResourcesGrid grid = new EIResourcesGrid( result );
				Datatools.showData( grid );
			}

			@Override
			public void loginRequired() {
				Datatools.hideGlasspane();
				Datatools.handleLoginRequired();
			}

			@Override
			public void onFailure(String error) {
				Datatools.hideGlasspane();
				Window.alert( UIMessages.COULD_NOT_FIND_RESOURCES_MESSAGE );
			}
		};
	}

	protected void drawView() {
		log.debug( "viewing " + ApplicationState.getInstance().getInstanceEntity() );
		Datatools.clearDataPanel();
		Datatools.showData( FormsPanelFactory.generateViewForm( ApplicationState.getInstance().getInstanceUri() ) );
	}

	protected void drawEdit() {
		log.debug( "editing " + ApplicationState.getInstance().getInstanceEntity() );
		Datatools.clearDataPanel();
		if ( !ApplicationState.getInstance().hasInstance() ) {
			Datatools.showData( FormsPanelFactory.generateNewForm( ApplicationState.getInstance().getTypeEntity() ) );
		} else {
			Datatools.showData( FormsPanelFactory.generateEditForm( ApplicationState.getInstance().getInstanceUri() ) );
		}
	}

	public void onLogIn(final String username, final String userUri) {
		log.debug( "main controller logged in, calling on AppStateChange; mode = " + ApplicationState.getInstance().getMode() + "; type = " + ApplicationState.getInstance().getTypeEntity() );
		onApplicationStateChange();
	}

	public void onLogOut() {
		onApplicationStateChange();
	}
}
