package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.LabCache.LabCacheListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;

public class Workbench extends Composite implements LabCacheListener {

	private final LabCache labCache;

	private FlowPanel mainPanel;
	private FocusPanel addLabPanel;
	private FocusPanel workWithLabsPanel;
	private FocusPanel workWithResourcesPanel;
	private FocusPanel toDoListPanel;

	private Anchor chooseLabLink;

	private FlowPanel chooseLabPanel;
	private FlowPanel chooseLabDropdownPanel;
	private ListBox labsList = new ListBox();

	private static final GWTLogger log = GWTLogger.getLogger( "Workbench" );

	public Workbench(LabCache labCache) {
		mainPanel = new FlowPanel();
		initWidget( mainPanel );
		mainPanel.setStyleName( "dtWorkBench" );

		this.labCache = labCache;
		labCache.addLabLoadListener( this );

		addLabPanel = new FocusPanel();
		addLabPanel.add( new HTML( "Create a Lab" ) );
		addLabPanel.setStyleName( "dtWbPanel" );
		addLabPanel.addStyleName( "dtWbCreateLab" );
		chooseLabLink = new Anchor( "Work with My Labs" );
		workWithLabsPanel = new FocusPanel();
		workWithLabsPanel.add( new HTML( "Browse Labs in My Institution" ) );
		workWithLabsPanel.setStyleName( "dtWbPanel" );
		workWithLabsPanel.addStyleName( "dtWbAllLabs" );
		workWithResourcesPanel = new FocusPanel();
		workWithResourcesPanel.add( new HTML( "Browse People & Resources in My Institution " ) );
		workWithResourcesPanel.setStyleName( "dtWbPanel" );
		workWithResourcesPanel.addStyleName( "dtWbResources" );
		toDoListPanel = new FocusPanel();
		toDoListPanel.add( new HTML( "Unfinished Tasks" ) );
		toDoListPanel.setStyleName( "dtWbPanel" );
		toDoListPanel.addStyleName( "dtWbTodo" );

		chooseLabPanel = new FlowPanel();
		chooseLabDropdownPanel = new FlowPanel();
		if ( labCache.isLoading() ) {
			labsList.addItem( "loading..." );
		} else {
			populateLabsList();
		}
		chooseLabPanel.add( new HTML( "Work With My Labs" ) );
		chooseLabPanel.add( chooseLabDropdownPanel );
		labsList.setStyleName( "dtWbCurrentLabSelect" );
		chooseLabDropdownPanel.add( labsList );
		chooseLabDropdownPanel.setStyleName( "dtWbCurrentLabsDropdown" );
		chooseLabPanel.setStyleName( "dtWbPanel" );
		chooseLabPanel.addStyleName( "dtWbCurrentLab" );

		mainPanel.add( chooseLabPanel );
		mainPanel.add( addLabPanel );

		mainPanel.add( workWithLabsPanel );
		mainPanel.add( workWithResourcesPanel );
		mainPanel.add( toDoListPanel );

		addLabPanel.addClickHandler( getAddLabHandler() );
		chooseLabLink.addClickHandler( getChooseLabHandler() );
		workWithLabsPanel.addClickHandler( getWorkWithLabsHandler() );
		workWithResourcesPanel.addClickHandler( getPeopleAndResourcesHandler() );
		toDoListPanel.addClickHandler( getToDoListHandler() );

		// toDoLink = new HTML("My to-do list");
		// toDoLink.setStyleName(style)
	}

	private ClickHandler getWorkWithLabsHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.labs, EIEntity.NULL_ENTITY, EagleIEntityConstants.EI_LAB_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private ClickHandler getChooseLabHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if ( labCache.isLoading() ) {
					Window.alert( "Labs are still loading. Please wait." );
				}
				chooseLabPanel.setVisible( true );
			}
		};
	}

	private ClickHandler getPeopleAndResourcesHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.resources, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private ClickHandler getAddLabHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.edit, EIEntity.NULL_ENTITY, EagleIEntityConstants.EI_LAB_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private ClickHandler getToDoListHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				ApplicationState.getInstance().updateApplicationState( Mode.stubs, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
			}
		};
	}

	private void populateLabsList() {
		labsList.clear();

		labsList.addItem( "select a lab" );
		for (final EIEntity lab : labCache.getLabEntities()) {
			labsList.addItem( lab.getLabel(), lab.getURI().toString() );
		}

		labsList.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				EIURI selectedUri = EIURI.create( labsList.getValue( labsList.getSelectedIndex() ) );
				EIEntity selectedEntity = labCache.getLab( selectedUri );
				if ( selectedEntity == null || selectedEntity.equals( EIEntity.NULL_ENTITY ) ) {
					return;
				}
				ApplicationState.getInstance().updateApplicationState( Mode.view, selectedEntity, EagleIEntityConstants.EI_LAB_ENTITY, selectedEntity );
			}
		} );

	}

	@Override
	public void onLabsLoaded() {
		populateLabsList();
	}

	public void resetSelectedLab() {
		labsList.setSelectedIndex( 0 );
	}

}
