package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.datatools.client.ui.OntologyPropEditRenderer;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

public class EIEmbeddedResourceEditWidget extends EditWidget{
	private static final GWTLogger log = GWTLogger.getLogger( "EIEmbeddedResourceEditWidget" );

	private DisclosurePanel embeddedPanel;
	private EIInstance embeddedInstance;
	private EIEntity embeddedClass;
	private NewInnerInstanceListener listener;
	
	
	public EIEmbeddedResourceEditWidget(final EIInstance outerInstance, final EIInstance embeddedInstance, final EIEntity embeddedClass, final EIEntity propertyEntity, String propertyDefinition, boolean isRequired, boolean showLabel, NewInnerInstanceListener listener) {
		super(outerInstance, propertyEntity, propertyDefinition, isRequired,Layout.Horizontal);
		log.debug("Outer instance is: " + outerInstance);
		log.debug( "Embedded instance is: " + embeddedInstance);
		this.embeddedClass = embeddedClass;
		this.isRequired = isRequired;
		this.shouldShowLabel = showLabel;
		this.listener = listener;
		if(embeddedInstance != null  && !EIInstance.NULL_INSTANCE.equals( embeddedInstance)) {
			setup(embeddedInstance);
		} else {
			getEmptyEmbeddedInstance();
		}
	}

	/**
	 * @param embeddedClass
	 * @param propertyEntity
	 */
	private void getEmptyEmbeddedInstance() {
		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance( embeddedClass.getURI(), new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance newInstance) {
					newInstance.setEmbedded( true );
					eiInstance.addEmbeddedInstance( propertyEntity, newInstance );
					setup( newInstance );
				}

				@Override
				public void onFailure(String error) {
					// TODO Auto-generated method stub
				}

				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
			});
	}

	private void setup(final EIInstance embeddedInstance) {
		this.embeddedInstance = embeddedInstance;
		embeddedPanel = new DisclosurePanel(propertyEntity.getLabel());
		embeddedPanel.setTitle( propertyDefinition );
		
		Anchor clearAllLink = new Anchor("clear all");
		
		HorizontalPanel mainPanel = new HorizontalPanel();
		VerticalPanel ontologyPanel = new VerticalPanel();
		addLinkClickHandler(clearAllLink, ontologyPanel);
		mainPanel.add( ontologyPanel ); 
		mainPanel.add( clearAllLink );
		new OntologyPropEditRenderer(this.embeddedInstance, ontologyPanel, listener);
		embeddedPanel.setContent(mainPanel);
		widgetPanel.add(embeddedPanel);
		setShouldShowLabel( false );
	}

	private void addLinkClickHandler(Anchor clearAllLink, final VerticalPanel ontologyPanel) {
		clearAllLink.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				ontologyPanel.clear();
				clearEmbeddedInstance();
				new OntologyPropEditRenderer(embeddedInstance, ontologyPanel, listener);
				
			}
		});
		
	}

	@Override
	public EditWidget duplicateBlank() {
		return new EIEmbeddedResourceEditWidget( eiInstance, EIInstance.NULL_INSTANCE, embeddedClass, propertyEntity, propertyDefinition, isRequired, false, listener );
	}

	@Override
	protected void removeValue() {
		clearEmbeddedInstance();		
	}
	
	@Override
	public void setShouldShowLabel(final boolean shouldShowLabel) {
		if ( !shouldShowLabel ) {
			// We do not intend to show the label again for Stub Widget
			widgetPanel.remove( label );
		}
	}

	/**
	 * 
	 */
	private void clearEmbeddedInstance() {
		embeddedInstance.setInstanceLabel( "" );
		embeddedInstance.setInstanceClass(embeddedInstance.getRootSuperType());
		embeddedInstance.getDatatypeProperties().clear();
		embeddedInstance.getObjectProperties().clear();
	}
	
}
