/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Set;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.OntologyPropertiesRenderer;
import org.eaglei.datatools.client.ui.widgets.EIEmbeddedResourceViewWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public class OntologyPropViewRenderer
extends OntologyPropertiesRenderer {
    private static final GWTLogger log = GWTLogger.getLogger((String)"OntologyPropertiesRenderer");

    public OntologyPropViewRenderer(EIInstance eiInstance, VerticalPanel ontologyPanel) {
        super(eiInstance, ontologyPanel);
    }

    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.ontologyPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
    }

    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (this.eiInstance.isPropertyValueAnEmbeddedInstance(propertyEntity)) {
            for (EIEntity propertyValue : propertyValues) {
                if (propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) continue;
                EIEmbeddedResourceViewWidget embeddedWidget = new EIEmbeddedResourceViewWidget(this.eiInstance.getEmbeddedInstance(propertyValue), propertyEntity, propertyDefinition);
                this.ontologyPanel.add((Widget)embeddedWidget);
            }
        } else {
            LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
            this.ontologyPanel.add((Widget)widget);
            boolean hadValue = false;
            for (EIEntity propertyValue : propertyValues) {
                if (propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) continue;
                hadValue = true;
                String displayValue = this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue) ? "* " + propertyValue.getLabel() : propertyValue.getLabel();
                Anchor a = new Anchor(InstanceWidgetUtils.formatText((String)displayValue));
                if (this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue)) {
                    a.addStyleName("Stub");
                }
                widget.add((Widget)a);
                a.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                if (hadValue) continue;
                this.ontologyPanel.remove((Widget)widget);
            }
        }
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText((String)value), InstanceWidgetUtils.formatText((String)value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText((String)InstanceWidgetUtils.insertBreaks((String)value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    private void getInstanceByURI(EIEntity entity) {
        try {
            ClientRepositoryToolsManager.INSTANCE.getInstance(entity.getURI(), (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    public Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }

    public void addFormTitle(String type) {
        if (this.eiInstance.isEmbeddedInstance()) {
            return;
        }
        HTML stubsMessage = null;
        if (this.eiInstance.hasStubs()) {
            stubsMessage = new HTML("* This resource links to unfinished resources.");
        } else if (this.eiInstance.isStub()) {
            stubsMessage = new HTML("This resource is unfinished. Please review and save.");
        }
        if (stubsMessage != null) {
            stubsMessage.setStyleName("StubMessage");
            this.ontologyPanel.add((Widget)stubsMessage);
        }
    }

    static /* synthetic */ GWTLogger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(OntologyPropViewRenderer x0, EIEntity x1) {
        x0.getInstanceByURI(x1);
    }
}

