/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ApplicationState;

public class PaginationWidget
extends FlowPanel {
    private final Anchor paginateButton = new Anchor(" paginate ");
    private final Anchor previousButton = new Anchor("< previous");
    private final Label disabledPreviousButton = new Label("< previous");
    private final Anchor nextButton = new Anchor("next >");
    private final Label countLabel;
    private final Anchor viewAllButton = new Anchor(" view all ");
    private final ListBox pageSizeList = new ListBox();

    public PaginationWidget(Integer offset, Integer count, Integer pageSize) {
        this.addClickHandlers(pageSize);
        this.initializePageSizeList();
        this.paginateButton.setStyleName("dtPaginateFrame");
        this.previousButton.setStyleName("dtPaginateFrame");
        this.disabledPreviousButton.setStyleName("dtPaginateFrame");
        this.disabledPreviousButton.addStyleName("dtPaginateDisabled");
        this.nextButton.setStyleName("dtPaginateFrame");
        this.viewAllButton.setStyleName("dtPaginateFrame");
        this.pageSizeList.addStyleName("dtPaginateFrame");
        if (offset != null && pageSize != null) {
            this.countLabel = new Label(" " + (offset + 1) + " - " + (pageSize + offset) + " ");
            this.countLabel.setStyleName("dtPaginateFrame");
            if (offset == 0) {
                this.add((Widget)this.disabledPreviousButton);
            } else {
                this.add((Widget)this.previousButton);
            }
            this.add((Widget)this.countLabel);
            this.add((Widget)this.nextButton);
            this.add((Widget)this.pageSizeList);
        } else {
            this.countLabel = new Label(" 1 - " + count + " ");
            this.countLabel.setStyleName("dtPaginateFrame");
            this.add((Widget)this.countLabel);
            this.add((Widget)this.pageSizeList);
        }
    }

    private void initializePageSizeList() {
        String[] options;
        for (String option : options = new String[]{"10", "20", "50", "100"}) {
            this.pageSizeList.addItem(option, option);
            if (ApplicationState.getInstance().getLimit() == null || !option.equals(ApplicationState.getInstance().getLimit().toString())) continue;
            this.pageSizeList.setSelectedIndex(this.pageSizeList.getItemCount() - 1);
        }
        this.pageSizeList.addItem("view all", "all");
        if (!ApplicationState.getInstance().isPaginated()) {
            this.pageSizeList.setSelectedIndex(this.pageSizeList.getItemCount() - 1);
        }
        this.pageSizeList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addClickHandlers(Integer pageSize) {
        this.paginateButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.nextButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.previousButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.viewAllButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ ListBox access$000(PaginationWidget x0) {
        return x0.pageSizeList;
    }
}

