/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;

public class ButtonsPanel
extends Composite {
    private static final int MINIMUM_EDIT_TRANSITIONS = 0;
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    protected Label formControlLabel;
    @UiField
    protected Label wfLabel;
    @UiField
    protected Button workFlowActionButton1;
    @UiField
    protected Button workFlowActionButton2;
    @UiField
    protected Button workFlowActionButton3;
    @UiField
    protected Button workFlowActionButton4;
    @UiField
    protected Button claimReleaseButton;
    @UiField
    protected Button saveButton;
    @UiField
    protected Button editButton;
    @UiField
    protected Button cancelButton;
    @UiField
    protected Button copyResourceButton;
    @UiField
    protected Button deleteButton;
    @UiField
    protected RadioButton onlyThisLab;
    @UiField
    protected RadioButton all;
    private final EIInstance instance;
    private EIClass rootSuperClass;
    private final FormRedisplay redisplay;
    private OwnershipAction ownershipAction;
    private final Map<Button, WorkFlowTransition> buttonTransitions = new HashMap();
    private final List<Button> workFlowButtons;
    private static final GWTLogger log = GWTLogger.getLogger((String)"ButtonsPanel");

    ButtonsPanel(EIInstance anInstance, FormRedisplay aRedisplay) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.instance = anInstance;
        this.redisplay = aRedisplay;
        this.workFlowButtons = Arrays.asList(this.workFlowActionButton1, this.workFlowActionButton2, this.workFlowActionButton3, this.workFlowActionButton4);
        this.setClaimOrReleaseButtonAction();
        this.setDeleteButtonAction();
        this.setWorkflowButtons();
        this.all.setVisible(false);
        this.onlyThisLab.setVisible(false);
    }

    public void setLabRestrictionSelector(LabRestrictionListener listener) {
        this.all.setValue(Boolean.valueOf(false));
        this.onlyThisLab.setValue(Boolean.valueOf(true));
        this.all.setVisible(false);
        this.onlyThisLab.setVisible(false);
        this.onlyThisLab.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.all.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setWorkflowButtons() {
        this.setEditingButtonState();
        this.buttonTransitions.clear();
        List legalTransitions = ClientRepositoryToolsManager.INSTANCE.getAllowedTransitions(this.instance);
        log.debug("Found " + (legalTransitions == null ? "null" : Integer.valueOf(legalTransitions.size())) + " legal transitions");
        this.wfLabel.setVisible(false);
        if (legalTransitions != null && legalTransitions.size() > 0) {
            int i = 0;
            for (WorkFlowTransition transition : legalTransitions) {
                if (transition.getFromStateURI().equals((Object)transition.getToStateURI())) {
                    log.debug("skipping " + transition.getName() + " because from and to are same");
                    continue;
                }
                if (!this.wfLabel.isVisible()) {
                    this.wfLabel.setVisible(true);
                }
                Button currentButton = (Button)this.workFlowButtons.get(i);
                currentButton.setVisible(true);
                this.setEnable(currentButton, ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance) && !this.isStub(this.instance));
                currentButton.setText(transition.getName());
                this.buttonTransitions.put(currentButton, transition);
                currentButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                ++i;
            }
            while (i < 4) {
                this.hide((Button)this.workFlowButtons.get(i));
                ++i;
            }
        } else {
            this.wfLabel.setVisible(false);
            this.hide(this.workFlowActionButton1);
            this.hide(this.workFlowActionButton2);
            this.hide(this.workFlowActionButton3);
            this.hide(this.workFlowActionButton4);
        }
    }

    private boolean isStub(EIInstance anInstance) {
        return anInstance.getNonOntologyLiteralProperties().containsKey(DatatoolsUIConstants.isStubEntity);
    }

    private void setEditingButtonState() {
        this.setEnable(this.editButton, ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance));
        this.setEnable(this.deleteButton, ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance));
    }

    private void hide(Button button) {
        this.setEnable(button, false);
        button.setVisible(false);
    }

    protected void setEnable(Button workflowButton, boolean enable) {
        workflowButton.setEnabled(enable);
        if (enable) {
            workflowButton.removeStyleName("btnDisabled");
        } else {
            workflowButton.addStyleName("btnDisabled");
        }
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public void setRootSuperClass(EIClass superclass) {
        this.rootSuperClass = superclass;
    }

    public void setClaimOrReleaseButtonAction() {
        this.claimReleaseButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (ClientRepositoryToolsManager.INSTANCE.canClaim(this.instance)) {
            this.claimReleaseButton.setText("Claim");
            this.ownershipAction = OwnershipAction.ClaimAction;
        } else if (ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance)) {
            this.claimReleaseButton.setText("Share");
            this.ownershipAction = OwnershipAction.ReleaseAction;
        } else {
            this.ownershipAction = OwnershipAction.ClaimAction;
            this.claimReleaseButton.setText("Claim");
            this.claimReleaseButton.setVisible(true);
            this.setEnable(this.claimReleaseButton, false);
        }
    }

    private void setDeleteButtonAction() {
        5 aynccallback = new /* Unavailable Anonymous Inner Class!! */;
        this.deleteButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void claimOrRelease() throws Exception {
        this.ownershipAction.perform(this.instance, (ActionRedisplay)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void hideAllWorkflowButtons() {
        this.wfLabel.setVisible(false);
        this.hide(this.workFlowActionButton1);
        this.hide(this.workFlowActionButton2);
        this.hide(this.workFlowActionButton3);
        this.hide(this.workFlowActionButton4);
    }

    public boolean isPresenlyOwner() {
        return this.instance.getWFOwner() != null && this.instance.getWFOwner().getURI().equals((Object)ApplicationState.getInstance().getUserURI());
    }

    static /* synthetic */ EIInstance access$000(ButtonsPanel x0) {
        return x0.instance;
    }

    static /* synthetic */ Map access$100(ButtonsPanel x0) {
        return x0.buttonTransitions;
    }

    static /* synthetic */ FormRedisplay access$200(ButtonsPanel x0) {
        return x0.redisplay;
    }

    static /* synthetic */ void access$300(ButtonsPanel x0) throws Exception {
        x0.claimOrRelease();
    }

    static /* synthetic */ GWTLogger access$400() {
        return log;
    }

    static /* synthetic */ EIClass access$500(ButtonsPanel x0) {
        return x0.rootSuperClass;
    }

    static /* synthetic */ OwnershipAction access$602(ButtonsPanel x0, OwnershipAction x1) {
        x0.ownershipAction = x1;
        return x0.ownershipAction;
    }

    static /* synthetic */ OwnershipAction access$600(ButtonsPanel x0) {
        return x0.ownershipAction;
    }
}

