/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.LabCache;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

public class LabCache
implements ClientRepositoryToolsManager.SessionListener {
    private final Map<String, EIEntity> labs = new HashMap();
    private final Map<EIURI, EIEntity> labUris = new HashMap();
    private boolean loading = true;
    private boolean loadStarted = false;
    private final List<LabCacheListener> listeners;
    private static final GWTLogger log = GWTLogger.getLogger((String)"LabCache");

    public LabCache() {
        log.debug("making new lab cache");
        this.listeners = new ArrayList();
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
    }

    public void update() {
        if (this.loadStarted) {
            return;
        }
        this.loading = true;
        this.loadStarted = true;
        log.debug("lab cache getting labs");
        try {
            AuthSearchRequest request = new AuthSearchRequest();
            request.setType(EagleIEntityConstants.EI_LAB_URI);
            request.setPaginated(false);
            ClientRepositoryToolsManager.INSTANCE.listResources(request, SortByProperties.label, false, (ClientRepositoryToolsManager.MinimalEIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
            Window.alert((String)("Unable to retrieve lisit of labs.  Error was " + e));
        }
    }

    public List<String> getLabLabels() {
        ArrayList<String> labels = new ArrayList<String>(this.labs.keySet());
        Collections.sort(labels);
        return labels;
    }

    public List<EIEntity> getLabEntities() {
        ArrayList<EIEntity> labEntities = new ArrayList<EIEntity>();
        for (String label : this.getLabLabels()) {
            labEntities.add((EIEntity)this.labs.get(label));
        }
        return labEntities;
    }

    public EIEntity getLab(String labLabel) {
        if (!this.labs.containsKey(labLabel)) {
            log.warn("trying to get nonexistent entry '" + labLabel + "'");
        }
        return (EIEntity)this.labs.get(labLabel);
    }

    public EIEntity getLab(EIURI labUri) {
        if (!this.labUris.containsKey(labUri)) {
            log.warn("trying to get nonexistent uri '" + labUri + "'");
        }
        return (EIEntity)this.labUris.get(labUri);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void addLabLoadListener(LabCacheListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (LabCacheListener listener : this.listeners) {
            listener.onLabsLoaded();
        }
    }

    public void onLogIn(String username, String userUri) {
        this.update();
    }

    public void onLogOut() {
        this.listeners.clear();
    }

    static /* synthetic */ Map access$000(LabCache x0) {
        return x0.labs;
    }

    static /* synthetic */ Map access$100(LabCache x0) {
        return x0.labUris;
    }

    static /* synthetic */ boolean access$202(LabCache x0, boolean x1) {
        x0.loading = x1;
        return x0.loading;
    }

    static /* synthetic */ boolean access$302(LabCache x0, boolean x1) {
        x0.loadStarted = x1;
        return x0.loadStarted;
    }

    static /* synthetic */ void access$400(LabCache x0) {
        x0.notifyListeners();
    }
}

