/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.Lab;
import org.eaglei.datatools.client.ui.OntologyPropertiesRenderer;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EIEmbeddedResourceEditWidget;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.ObjectWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.datatools.client.ui.widgets.TypeWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class OntologyPropEditRenderer
extends OntologyPropertiesRenderer {
    protected final List<EIEntity> dataPropEntityList = new ArrayList();
    protected final List<EIEntity> booleanPropEntityList = new ArrayList();
    protected final List<EIEntity> objPropEntityList = new ArrayList();
    protected final Map<EIEntity, List<EIClass>> objectPropertyRanges = new HashMap();
    private final EIEntity labEntity = ApplicationState.getInstance().getLabEntity();
    private static final GWTLogger log = GWTLogger.getLogger((String)"OntologyPropEditRenderer");
    private final NewInnerInstanceListener listener;

    public OntologyPropEditRenderer(EIInstance eiInstance, VerticalPanel ontologyPanel, NewInnerInstanceListener innerListener) {
        super(eiInstance, ontologyPanel);
        this.listener = innerListener;
    }

    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        if (propertyEntity.equals((Object)EagleIEntityConstants.RDFS_LABEL_ENTITY)) {
            this.ontologyPanel.add((Widget)TextWidget.makeLabelTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (String)propertyValues.iterator().next()));
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (this.booleanPropEntityList.contains(propertyEntity)) {
                this.ontologyPanel.add((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, null));
            } else {
                this.ontologyPanel.add((Widget)new EditWidgetCollection(this.eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, null)));
            }
        } else {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            for (String value : propertyValues) {
                if (this.booleanPropEntityList.contains(propertyEntity)) {
                    fields.addWithoutModifiers((Widget)WidgetUtils.createRadioButon((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (String)value));
                    continue;
                }
                fields.addWidget(TextWidget.makeDatatypeTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (String)value));
            }
            fields.setStyleName("required");
            this.ontologyPanel.add((Widget)fields);
        }
    }

    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (propertyEntity.equals((Object)EagleIEntityConstants.RDF_TYPE_ENTITY)) {
            this.drawTypeProperty();
        } else if (this.objectPropertyRanges.get(propertyEntity) != null && ((List)this.objectPropertyRanges.get(propertyEntity)).size() > 0) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            this.ontologyPanel.add((Widget)fields);
            if (((List)this.objectPropertyRanges.get(propertyEntity)).size() == 1) {
                this.drawSingleObjectProperty(propertyEntity, propertyDefinition, isRequired, propertyValues, fields);
            } else {
                log.info(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : Integer.valueOf(propertyValues.size())) + "entries");
                if (propertyValues == null || propertyValues.size() == 0) {
                    this.createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, null, fields);
                } else {
                    for (EIEntity selectedEntity : propertyValues) {
                        this.createWidgetForMultiRanges(propertyEntity, propertyDefinition, isRequired, selectedEntity, fields);
                    }
                }
            }
        }
    }

    private void drawSingleObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues, EditWidgetCollection fields) {
        EIClass range = (EIClass)((List)this.objectPropertyRanges.get(propertyEntity)).iterator().next();
        if (this.hasLabUri() && this.isLabRelatedProperty(propertyEntity)) {
            log.info("making disabled widget for lab uri '" + this.labEntity + "' property " + range.getEntity().getLabel());
            this.eiInstance.addObjectProperty(propertyEntity, this.labEntity);
            this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, this.labEntity, fields, true);
        } else if (propertyValues == null || propertyValues.size() == 0) {
            if (InstanceWidgetUtils.isLabProperty((EIClass)range)) {
                log.info("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
            }
            this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, fields, false);
        } else {
            if (InstanceWidgetUtils.isLabProperty((EIClass)range)) {
                log.info("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
            }
            for (EIEntity selectedEntity : propertyValues) {
                this.createWidgetForRange(propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, false);
            }
        }
    }

    private boolean isDataModelCreateRange(EIClass range) {
        if (ApplicationState.getInstance().getResourceTypesForLab() == null) {
            return false;
        }
        return ApplicationState.getInstance().getResourceTypesForLab().contains(range);
    }

    protected boolean hasLabUri() {
        return this.labEntity != null && this.labEntity.getURI() != EIURI.NULL_EIURI && !this.labEntity.getURI().toString().equals("");
    }

    private void drawTypeProperty() {
        HorizontalPanel temp = new HorizontalPanel();
        this.ontologyPanel.add((Widget)temp);
        TypeWidget typeWidget = new TypeWidget(this.eiInstance, EagleIEntityConstants.RDF_TYPE_ENTITY, this.eiInstance.getRootSuperType(), this.eiInstance.getInstanceClass(), (TypeWidget.TypeChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        temp.add((Widget)typeWidget);
    }

    private void createWidgetForMultiRanges(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIEntity selectedEntity, EditWidgetCollection fields) {
        log.info("making multi-range widget with " + ((List)this.objectPropertyRanges.get(propertyEntity)).size() + " ranges");
        ObjectWidget widget = new ObjectWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, (List)this.objectPropertyRanges.get(propertyEntity), this.labEntity, selectedEntity, this.isLabRelatedProperty(propertyEntity), this.listener);
        fields.addWidget((EditWidget)widget, widget.isDisabled());
    }

    private void createWidgetForRange(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, EditWidgetCollection fields, boolean isLab) {
        if (ApplicationState.getInstance().getEmbeddedClasses().contains(range)) {
            this.addEmbeddedInstanceWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, fields, true);
        } else if (range.isEagleIResource()) {
            boolean isLabRelatedProperty = this.isLabRelatedProperty(propertyEntity);
            EIResourceListWidget resourceWidget = new EIResourceListWidget(this.eiInstance, propertyEntity, propertyDefinition, isRequired, range, selectedEntity, true, isLabRelatedProperty, this.listener);
            fields.addWidget((EditWidget)resourceWidget, isLab);
            if (isLab) {
                resourceWidget.disableAsLabProperty();
            }
        } else {
            WidgetUtils.addTermWidgetToPanel((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired, (EIClass)range, (EIEntity)selectedEntity, (EditWidgetCollection)fields, (boolean)true);
        }
    }

    private boolean isLabRelatedProperty(EIEntity propertyEntity) {
        if (((EIProperty)this.eiPropertiesEntityMap.get(propertyEntity)).getAnnotations() == null) {
            return false;
        }
        return ((EIProperty)this.eiPropertiesEntityMap.get(propertyEntity)).getAnnotations().contains("http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab");
    }

    private void addEmbeddedInstanceWidget(EIInstance outerInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, EditWidgetCollection fields, boolean showLabel) {
        EIInstance embeddedInstance = outerInstance.getEmbeddedInstance(selectedEntity);
        EIEmbeddedResourceEditWidget widget = new EIEmbeddedResourceEditWidget(outerInstance, embeddedInstance, range.getEntity(), propertyEntity, propertyDefinition, isRequired, showLabel, this.listener);
        fields.addWidget((EditWidget)widget);
    }

    protected void finishSetup() {
        this.dataPropEntityList.clear();
        this.objPropEntityList.clear();
        this.objectPropertyRanges.clear();
        this.booleanPropEntityList.clear();
        this.propertyInitializationCallback();
    }

    private void propertyInitializationCallback() {
        for (EIProperty property : this.eiProperties) {
            if (property instanceof EIDatatypeProperty) {
                this.dataPropEntityList.add(property.getEntity());
                if (!((EIDatatypeProperty)property).getTypeLabel().equals("boolean")) continue;
                this.booleanPropEntityList.add(property.getEntity());
                continue;
            }
            if (!(property instanceof EIObjectProperty)) continue;
            this.objPropEntityList.add(property.getEntity());
            List assertedRanges = ((EIObjectProperty)property).getRangeList();
            ArrayList<EIClass> rangesMinusDataModelCreate = new ArrayList<EIClass>();
            if (Lab.isLabType((EIEntity)this.eiInstance.getInstanceType())) {
                log.debug("Processing lab form");
                for (EIClass range : assertedRanges) {
                    log.debug("Processing range for lab form: " + range);
                    if (this.isDataModelCreateRange(range)) continue;
                    log.debug("Found range not annotated to DatatoolsCreate");
                    rangesMinusDataModelCreate.add(range);
                }
            } else {
                rangesMinusDataModelCreate.addAll(assertedRanges);
            }
            log.debug("Processing property: " + property.getEntity() + " with number of ranges: " + rangesMinusDataModelCreate.size());
            if (rangesMinusDataModelCreate.isEmpty()) continue;
            this.objectPropertyRanges.put(property.getEntity(), rangesMinusDataModelCreate);
        }
        super.finishSetup();
    }

    public Collection<EIEntity> getDataTypeEntities() {
        return this.dataPropEntityList;
    }

    public Collection<EIEntity> getObjectTypeEntities() {
        return this.objPropEntityList;
    }

    public void addFormTitle(String type) {
    }

    static /* synthetic */ GWTLogger access$000() {
        return log;
    }
}

