package org.eaglei.datatools.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class WorkFlowConstants {
	public static final EIURI WITHDRAW_URI = EIURI.create( "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn" );
	public static final EIURI PUBLISH_URI = EIURI.create( "http://eagle-i.org/ont/repo/1.0/WFS_Published" );
	public static final EIURI CURATION_URI = EIURI.create( "http://eagle-i.org/ont/repo/1.0/WFS_Curation" );
	public static final EIURI DRAFT_URI = EIURI.create( "http://eagle-i.org/ont/repo/1.0/WFS_Draft" );
	public static final EIURI NEW_URI = EIURI.create( "http://eagle-i.org/ont/repo/1.0/WFS_New" );
	// Repo Constants from DataToolsOntConstants
	public static final String EAGLE_I_REPO_URI = "http://eagle-i.org/ont/repo/1.0/";

	public static final String CURATION_ACTION = "Send to Curation";
	public static final String PUBLISH_ACTION = "Publish";
	public static final String DRAFT_ACTION = "Return to Draft";
	public static final String WITHDRAW_ACTION = "Withdraw";
	public static final String CLAIM_ALL_ACTION = "Claim";
	public static final String RELEASE_ALL_ACTION = "Share";
	// States
	public static final String CURATION_STATE_LABEL = "In curation";
	public static final String PUBLISH_STATE_LABEL = "Published";
	public static final String DRAFT_STATE_LABEL = "Draft";
	public static final String WITHDRAW_STATE_LABEL = "Withdrawn";

	// State entities
	public static final EIEntity CURATION_ENTITY = EIEntity.create( CURATION_URI, CURATION_STATE_LABEL );
	public static final EIEntity PUBLISH_ENTITY = EIEntity.create( PUBLISH_URI, PUBLISH_STATE_LABEL );
	public static final EIEntity DRAFT_ENTITY = EIEntity.create( DRAFT_URI, DRAFT_STATE_LABEL );
	public static final EIEntity WITHDRAW_ENTITY = EIEntity.create( WITHDRAW_URI, WITHDRAW_STATE_LABEL );

	public static final Map<EIURI, EIEntity> WORKFLOW_URI_MAP = new HashMap<EIURI, EIEntity>() {
		{
			put( CURATION_URI, CURATION_ENTITY );
			put( PUBLISH_URI, PUBLISH_ENTITY );
			put( DRAFT_URI, DRAFT_ENTITY );
			put( WITHDRAW_URI, WITHDRAW_ENTITY );
		}
	};

	public static final List<EIEntity> WORKFLOW_ENTITY_LIST = new ArrayList<EIEntity>( WORKFLOW_URI_MAP.values() );

	private String statusType;

	public String getStatusType() {
		return statusType;
	}

	public EIEntity getStatusEntity(final String status) {
		if ( DRAFT_STATE_LABEL.equals( status ) ) {
			return DRAFT_ENTITY;
		} else if ( CURATION_STATE_LABEL.equals( status ) ) {
			return CURATION_ENTITY;
		} else if ( PUBLISH_STATE_LABEL.equals( status ) ) {
			return PUBLISH_ENTITY;
		} else if ( WITHDRAW_STATE_LABEL.equals( status ) ) {
			return WITHDRAW_ENTITY;
		}
		return EIEntity.NULL_ENTITY;
	}
}
