package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The GWT client side stub for the RPC service to the repository
 */
@RemoteServiceRelativePath("repository")
public interface RepositoryToolsModelService extends RepositoryProvider, RemoteService {

	public EIClass getRootSuperclassForInstanceUri(Session session, EIURI instanceUri) throws Exception;

	public List<EIClass> getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri) throws Exception;

	public EIClass getRootSuperClass(EIClass eclass) throws Exception;

	public EIClass getSuperClass(EIClass eclass) throws Exception;

	public List<EIProperty> getAllEquivalentClasses(List<EIProperty> propertiesToPopulate);
	
	public List<EIClass> getTopClassesAnotatedByDataModelCreate() throws Exception;
	
	public boolean isModelClassURI(EIURI uri);
}
