package org.eaglei.datatools.client.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class DataToolsBasicInstancePanel<T extends OntologyPropertiesRenderer> extends Composite {
	
	
	private OntologyPropertiesRenderer opr;
	protected final VerticalPanel outerFormPanel = new VerticalPanel();
	//FIXME one level of nesting too much; remove formPanel
	protected VerticalPanel formPanel = new VerticalPanel();
	protected VerticalPanel ontologyPanel = new VerticalPanel();
	protected EIInstance eiInstance;
	protected T ontologyPropRenderer;

	protected abstract void drawAdminProperties();

	protected abstract void drawReferencedBy();
	
	protected abstract void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties);
	
	protected abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

	protected abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

	protected boolean shouldShowReadOnlyProperties = true; // TODO: We probably had this when we shared code with search. Can be removed completely.

	public DataToolsBasicInstancePanel(final EIInstance instance) {
		eiInstance = instance;
		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
		ontologyPanel.setStyleName( "formPanel" );
		initializeSpecifics();
	}

	protected DataToolsBasicInstancePanel() {
		// NOTE: ONLY to be called by subclasses that need to set other instance variables before doing stuff
		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
		ontologyPanel.setStyleName( "formPanel" );
	}

	protected void initializeSpecifics() {
		formPanel.add(ontologyPanel);
		constructForm();
		outerFormPanel.add(formPanel);
	}

	public EIInstance getInstance() {
		return eiInstance;
	}
	
	protected void constructForm() {
		//ontology properties moved to ontology renderer
		final Map<EIEntity, Set<String>> instanceNonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();
		drawExtraFields(instanceNonOntologyLiteralProperties);
		drawReferencedBy();
		drawAdminProperties();	

	}

	protected HashSet<String> makeSetFromSingle(final String value) {
		return new HashSet<String>(Arrays.asList(new String[] { value }));
	}

	protected HashSet<EIURI> makeSetFromSingleURI(final EIURI value) {
		return new HashSet<EIURI>(Arrays.asList(new EIURI[] { value }));
	}

	protected HashSet<EIEntity> makeSetFromSingleEntity(final EIEntity value) {
		return new HashSet<EIEntity>(Arrays.asList(new EIEntity[] { value }));
	}

	protected Widget handleReadOnlyTextProperty(final String value) {
		if (value.startsWith("www") || value.startsWith("http")) {
			// For values that have external URIs
			return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
		} else {
			final HTML valueField = new HTML(InstanceWidgetUtils.formatText( InstanceWidgetUtils.insertBreaks( value )));
			valueField.setStyleName("formLabelValue");
			return valueField;
		}
	}

	protected void drawReadOnlyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final Map<EIEntity, String> labelMap, final VerticalPanel nonOntologyPanel) {
		final String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);

		final LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (final String value : propertyValues) {
			widget.add(handleReadOnlyTextProperty(value));
		}
		nonOntologyPanel.add(widget);
	}

	protected void drawReadOnlyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final Map<EIEntity, String> labelMap, final VerticalPanel nonOntologyPanel) {
		final String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);

		final LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (final EIEntity propEntity : propertyValues) {
			if (propEntity != null && propEntity != EIEntity.NULL_ENTITY) {
				widget.add(handleReadOnlyTextProperty(propEntity.getLabel()));
			}
		}
		nonOntologyPanel.add(widget);
	}


}
