package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public abstract class DatatoolsInstancePanel extends DataToolsBasicInstancePanel<OntologyPropertiesRenderer> {

	protected FormRedisplay redisplayCallbacks;
	protected ButtonsPanel buttonPanel;

	
	protected abstract void setButtonState();

	protected abstract void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, VerticalPanel nonOntologyPanel);

	protected abstract void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, VerticalPanel nonOntologyPanel);

	public DatatoolsInstancePanel(final EIInstance instance, final FormRedisplay redisplay) {
		redisplayCallbacks = redisplay;
		eiInstance = instance;
		initializeSpecifics();
	}

	@Override
	protected void initializeSpecifics() {
		buttonPanel = new ButtonsPanel( eiInstance, redisplayCallbacks );
		outerFormPanel.add( buttonPanel );
		buttonPanel.copyResourceButton.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent event) {
				redisplayCallbacks.drawAfterDuplicate( eiInstance );
			}
		} );

		setButtonState();

		super.initializeSpecifics();

	}

	@Override
	protected void drawAdminProperties() { 
		final DisclosurePanel nonOntologyPanel = new DisclosurePanel( "Information for data curators" );

		final Map<EIEntity, Set<String>> instanceNonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();
		final Map<EIEntity, Set<EIEntity>> instanceNonOntologyResourceProperties = eiInstance.getNonOntologyResourceProperties();
	
		final List<EIEntity> entityList = new ArrayList<EIEntity>();
		entityList.addAll( eiInstance.getReadOnlyLiteralProperties().keySet() );
		entityList.addAll( eiInstance.getReadOnlyResourceProperties().keySet() );
		entityList.addAll( instanceNonOntologyLiteralProperties.keySet() );
		entityList.addAll( instanceNonOntologyResourceProperties.keySet() );

		final VerticalPanel innerPanel = new VerticalPanel();
		createNonOntologyPanel( instanceNonOntologyLiteralProperties, instanceNonOntologyResourceProperties, innerPanel );

		nonOntologyPanel.add( innerPanel );
		formPanel.add( nonOntologyPanel );
	}

	protected void createNonOntologyPanel(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties, final Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, final VerticalPanel innerPanel) {
		final VerticalPanel metaPanel = new VerticalPanel();
		final VerticalPanel otherPanel = new VerticalPanel();
		designPanel( metaPanel, "Metadata properties:" );
		designPanel( otherPanel, "Other properties:" );

		final LabelValuesWidget eagleIUniqueId = new LabelValuesWidget( "eagle-i unique ID" );
		final Anchor id = new Anchor( eiInstance.getInstanceURI().toString(), eiInstance.getInstanceURI().toString(), "_blank" );
		eagleIUniqueId.add( id );
		innerPanel.add( eagleIUniqueId ); 
		if ( shouldShowReadOnlyProperties ) {
			innerPanel.add( metaPanel );
			innerPanel.add( otherPanel );

			final Map<EIEntity, String> readOnlyLiterals = eiInstance.getReadOnlyLiteralProperties();
			final Map<EIEntity, EIEntity> readOnlyResources = eiInstance.getReadOnlyResourceProperties();

			drawReadOnlyProperties( null, metaPanel, readOnlyLiterals, readOnlyResources );
		}

		final VerticalPanel panelToUse = shouldShowReadOnlyProperties ? otherPanel : innerPanel;
		for (final EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
			drawNonOntologyLiteralProperty( propEntity, nonOntologyLiteralProperties.get( propEntity ), panelToUse );
		}

		for (final EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
			drawNonOntologyResourceProperty( propEntity, nonOntologyResourceProperties.get( propEntity ), panelToUse );
		}

	}

	private void drawReadOnlyProperties(final Map<EIEntity, String> labelMap, final VerticalPanel metaPanel, final Map<EIEntity, String> readOnlyLiterals, final Map<EIEntity, EIEntity> readOnlyResources) {
		for (final EIEntity propEntity : readOnlyLiterals.keySet()) {
			drawReadOnlyLiteralProperty( propEntity, makeSetFromSingle( readOnlyLiterals.get( propEntity ) ), labelMap, metaPanel );
		}

		for (final EIEntity propEntity : readOnlyResources.keySet()) {
			drawReadOnlyResourceProperty( propEntity, makeSetFromSingleEntity( readOnlyResources.get( propEntity ) ), labelMap, metaPanel );
		}
	}

	private void designPanel(final VerticalPanel panel, final String header) {
		panel.setStyleName( "formPanel" );

		final Label propHeader = new Label( header );
		propHeader.setStyleName( "nonOntologyPropertyLabel" );
		panel.add( propHeader );
	}

}
