package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SaveResultsCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.TokenCallback;
import org.eaglei.datatools.client.ui.ButtonsPanel.LabRestrictionListener;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class EditFormsPanel extends DatatoolsInstancePanel implements NewInnerInstanceListener {

	static enum EditFormType {
		Edit, New, Dialog;
	}

	public interface PropertiesLoadedListener {

		void onPropertiesLoaded();
	}

	private final List<EIInstance> newInnerInstances = new ArrayList<EIInstance>(); // TODO: probably NOT extended; these may include embedded
	private String editToken;
	//private Map<EIInstance, String> embeddedTokens = new HashMap<EIInstance, String>(); // TODO: merge with other token
	private final EditFormType formType;
	private final EditFormRedisplay formRedisplayCallbacks;

	private static final GWTLogger log = GWTLogger.getLogger( "EditFormsPanel" );

	public static EditFormsPanel createEditForm(final EIInstance instance, final EIEntity labEntity, final EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel( instance, labEntity, displayCallbacks, EditFormType.Edit );
	}

	public static EditFormsPanel createNewForm(final EIInstance instance, final EIEntity labEntity, final EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel( instance, labEntity, displayCallbacks, EditFormType.New );
	}

	private EditFormsPanel(final EIInstance instance, final EIEntity labEntity, final EditFormRedisplay displayCallbacks, final EditFormType formType) {
		super( instance, displayCallbacks );
		log.debug( "creaing edit renderer for instance " + eiInstance );
		ontologyPropRenderer = new OntologyPropEditRenderer( eiInstance, ontologyPanel, this );
		buttonPanel.setRootSuperClass( ontologyPropRenderer.getRootSuperClass() );
		shouldShowReadOnlyProperties = true;
		formRedisplayCallbacks = displayCallbacks;
		this.formType = formType;
		setButtonState(); // in order to get new/edit
		if ( ! isNewForm() ) {
			getEditToken();
		}
		if ( Lab.isLabType( instance.getInstanceType() ) ) {
			ApplicationState.getInstance().setLabEntity( instance.getEntity() ); // deliberately bypass other update mechanisms
		}
		

		if ( buttonPanel.getSaveButton().isEnabled() ) {
			buttonPanel.getSaveButton().addClickHandler( new ClickHandler() {

				@Override
				public void onClick(final ClickEvent event) {
					save();
				}
			} );
		}

		if ( buttonPanel.getCancelButton().isEnabled() ) {
			buttonPanel.getCancelButton().addClickHandler( new ClickHandler() {

				@Override
				public void onClick(final ClickEvent event) {
					cancel();
				}
			} );
		}

		buttonPanel.setLabRestrictionSelector( new LabRestrictionListener() {

			@Override
			public void selectAll() {
				// TODO Auto-generated method stub

			}

			@Override
			public void selectOnlyLab() {
				// TODO Auto-generated method stub

			}

		} );

	}

	public boolean isNewForm() {
		return formType == EditFormType.New;
	}

	@Override
	protected void drawNonOntologyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final VerticalPanel nonOntologyPanel) {
		if ( !propertyEntity.getURI().toString().equals( DatatoolsUIConstants.COMMENTS ) && !propertyEntity.getURI().toString().equals( DatatoolsUIConstants.CURATOR_NOTE ) ) {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			nonOntologyPanel.add( fields );
			for (final String value : propertyValues) {
				fields.addWidget( TextWidget.makeNonOntologyTextWidget( eiInstance, propertyEntity, value ) );
			}
		}
	}

	@Override
	protected void drawNonOntologyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final VerticalPanel nonOntologyPanel) {
		final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
		nonOntologyPanel.add( fields );
		for (final EIEntity value : propertyValues) {
			fields.addWidget( TextWidget.makeNonOntologyTextWidget( eiInstance, propertyEntity, value.getLabel() ) );
		}
	}

	@Override
	protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	protected void drawExtraFields(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		final Label commentOnComments = new Label( UIMessages.COMMENT_ON_COMMENTS );
		commentOnComments.setStyleName( "commentOnComments" );
		formPanel.add( commentOnComments );
		final EIEntity comments = EIEntity.create( DatatoolsUIConstants.COMMENTS, DatatoolsUIConstants.COMMENTS_LABEL );
		final EIEntity curatorComments = EIEntity.create( DatatoolsUIConstants.CURATOR_NOTE, DatatoolsUIConstants.CURATOR_LABEL );
		final String commentValue = nonOntologyLiteralProperties.containsKey( comments ) ? nonOntologyLiteralProperties.get( comments ).iterator().next() : null;
		final TextAreaWidget commentsArea = TextAreaWidget.makeNonOntologyTextArea( eiInstance, comments, "", false, commentValue );
		formPanel.add( commentsArea );
		final String curatorValue = nonOntologyLiteralProperties.containsKey( curatorComments ) ? nonOntologyLiteralProperties.get( curatorComments ).iterator().next() : null;
		final TextAreaWidget curatorArea = TextAreaWidget.makeNonOntologyTextArea( eiInstance, curatorComments, "", false, curatorValue );
		formPanel.add( curatorArea );
	}

	protected void save() { // TODO: handle stale token correctly
		if ( !checkLabels() ) {
			Window.alert( UIMessages.LABEL_REQUIRED );
			return;
		}

		try {

			saveNewInnerInstances();

		} catch (final Exception e) {
			log.error( "could not (re-) get instance" );
		}
	}

	private void saveMainInstance() throws Exception {
		if ( isNewForm() ) {
			saveNewForm();
		} else {
			if ( eiInstance.getNonOntologyLiteralProperties().containsKey( DatatoolsUIConstants.isStubEntity ) ) {
				eiInstance.replaceNonOntologyLiteralPropertyAllValues( DatatoolsUIConstants.isStubEntity, new HashSet<String>() );
			}
			ClientRepositoryToolsManager.INSTANCE.updateInstance( eiInstance, editToken, new SaveResultsCallback() {

				@Override
				public void onSuccess() {
					formRedisplayCallbacks.drawAfterSave( eiInstance );
				}

				@Override
				public void loginRequired() {
					Window.alert( UIMessages.PLEASE_LOGIN );
				}

				@Override
				public void onFailure() {
					Window.alert( UIMessages.SAVE_FAILURE );
					formRedisplayCallbacks.drawAfterCancel( eiInstance );
				}
			} );
		}
	}

	private void saveNewInnerInstances() throws Exception {
		if ( newInnerInstances.size() == 0 ) {
			log.debug( "no inner instances" );
			//saveExistingInnerInstances();
			saveMainInstance();
		} else {
			deduplicate();
			log.info( "saving new inner instances" ); // TODO: remove
			ClientRepositoryToolsManager.INSTANCE.createInstances( newInnerInstances, new EIInstancesCallback() {
	
				@Override
				public void loginRequired() {
	
				}
	
				@Override
				public void onSuccess(List<EIInstance> result) {
					try {
						//saveExistingInnerInstances();
						saveMainInstance();
					} catch (Exception e) {
						log.error( "could not (re-) get instance" );
					}
				}
	
				@Override
				public void onFailure(String error) {
					Window.alert( "unable to create stubs and embedded resources" );
				}
			} );
		}
	}

	private void deduplicate() {
		List<EIInstance> ignore = new ArrayList<EIInstance>();
		
		for (EIInstance instance : newInnerInstances ) {
			if (ignore.contains( instance )) {
				continue;
			}
			for (EIInstance otherInstance : newInnerInstances) {
				if ( ignore.contains( otherInstance ) ) {
					continue;
				}
				
				if ( isDuplicate(instance, otherInstance) ) {
					EIEntity property = eiInstance.findPropertyForInstance( otherInstance.getEntity() );
					eiInstance.replaceObjectPropertyValue( property, otherInstance.getInstanceURI(), instance.getEntity() );
					ignore.add( otherInstance );
				}
			}
		}
		
		newInnerInstances.removeAll( ignore );
	}

	private boolean isDuplicate(EIInstance instance, EIInstance otherInstance) {
		if ( instance == otherInstance || instance.getEntity().equals( otherInstance.getEntity() ) ) {
			return false; // not a duplicate of itself
		}
		
		// duplicate if type & label are identical
		return instance.getInstanceType().equals(otherInstance.getInstanceType()) && instance.getInstanceLabel().equals(otherInstance.getInstanceLabel());
	}

	/*private void saveExistingInnerInstances() throws Exception {
		if ( embeddedTokens.size() == 0 ) {
			saveMainInstance();
		} else {
			ClientRepositoryToolsManager.INSTANCE.updateInstances( embeddedTokens, new SaveResultsCallback() {

				@Override
				public void onFailure() {
					Window.alert( "unable to update embedded resources" );
				}

				@Override
				public void onSuccess() {
					try {
						saveMainInstance();
					} catch (Exception e) {
						log.error( "could not (re-) get instance" );
					}
				}

				@Override
				public void loginRequired() {

				}

			} );
		}
	}*/

	private boolean checkLabels() {
		if ( isMissingLabel( eiInstance ) ) {
			return false;
		}

		for (EIInstance inner : newInnerInstances) {
			if ( isMissingLabel( inner ) ) {
				return false;
			}
		}
		
		for (EIInstance inner : eiInstance.getEmbeddedInstanceList()) {
			if ( isMissingLabel( inner ) && inner.getObjectProperties().isEmpty() && inner.getDatatypeProperties().isEmpty() && !inner.getInstanceClass().equals(inner.getRootSuperType())) {
				return false;
			}
		}


		return true;
	}

	private boolean isMissingLabel(EIInstance instance) {
		return instance.getInstanceLabel() == null || instance.getInstanceLabel().trim().equals( "" );
	}

	private void saveNewForm() throws Exception {
		ClientRepositoryToolsManager.INSTANCE.createInstance( eiInstance, new EIInstanceCallback() {

			@Override
			public void onSuccess(final EIInstance saved) {
				log.info( "drawing " + saved.getInstanceLabel() + " after saving" );
				formRedisplayCallbacks.drawAfterSave( saved );
			}

			@Override
			public void loginRequired() {
				Window.alert( UIMessages.PLEASE_LOGIN );
			}

			@Override
			public void onFailure(String error) {
				Window.alert( UIMessages.SAVE_FAILURE );
			}
		} );
	}

	private void cancel() {
		try {
			if ( formType == EditFormType.New ) {
				if ( Lab.isLabType( eiInstance.getInstanceType() ) ) {
					ApplicationState.getInstance().updateApplicationState( Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
				} else if ( ApplicationState.getInstance().getMode() == Mode.duplicate ) {
					History.back();
				} else {
					 EIEntity typeEntity = eiInstance.getRootSuperType().getEntity();
					 ApplicationState.getInstance().updateApplicationState( Mode.list, EIEntity.NULL_ENTITY, typeEntity, ApplicationState.getInstance().getLabEntity() );
				}
			} else {
				ClientRepositoryToolsManager.INSTANCE.getInstance( eiInstance.getInstanceURI(), new EIInstanceCallback() {

					@Override
					public void loginRequired() {
					}

					@Override
					public void onSuccess(final EIInstance fetched) {
						formRedisplayCallbacks.drawAfterCancel( fetched );
					}

					@Override
					public void onFailure(String error) {
						formRedisplayCallbacks.drawAfterCancel( eiInstance );
					}
				} );
			}
		} catch (final Exception e) {
			log.error( "could not get instance" );
		}
	}

	@Override
	protected void setButtonState() {
		buttonPanel.saveButton.setVisible( true );
		if ( formType == EditFormType.New ) {
			buttonPanel.copyResourceButton.setVisible( false );
			buttonPanel.cancelButton.setVisible( true );

		} else {
			buttonPanel.copyResourceButton.setVisible( true );
			buttonPanel.cancelButton.setVisible( true );
			buttonPanel.hideAllWorkflowButtons();
		}
		buttonPanel.editButton.setVisible( false );
		buttonPanel.claimReleaseButton.setVisible( false );
		buttonPanel.deleteButton.setVisible( false );
	}

	private void getEditToken() {
		try {
			ClientRepositoryToolsManager.INSTANCE.getToken( eiInstance, new TokenCallback() {

				@Override
				public void loginRequired() {
					Window.alert( UIMessages.PLEASE_LOGIN );
				}

				@Override
				public void onFailure(String message) {
					log.warn( "failed to get edit token for " + eiInstance );
					Window.alert( UIMessages.NO_TOKEN_AVAILABLE );
				}

				@Override
				public void onSuccess(String token) {
					editToken = token;
				}
			} );

		} catch (final Exception e) {
			log.error( "failed to get edit token for " + eiInstance + " with exception" );
			Window.alert( UIMessages.NO_TOKEN_AVAILABLE );
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.ui.EIFormsPanel#drawReferencedBy()
	 */
	@Override
	protected void drawReferencedBy() {
		// deliberate no-op
		// Edit form doesn't display referenced by link
	}

	@Override
	public void onInstanceAdded(EIInstance newInstance) {
		newInnerInstances.add( newInstance );
	}

	@Override
	public void onInstanceRemoved(EIInstance newInstance) {
		newInnerInstances.remove( newInstance );
	}
}
