package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.datatools.client.ui.DataToolsBasicInstancePanel;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Creates a Form Panel. This is a common class for Labs & Resources
 * 
 * @author pp101
 * 
 */
public class FormsPanelFactory {
	
	private static final GWTLogger log = GWTLogger.getLogger("FormsPanelFactory");
	
	@Deprecated
	private FormsPanelFactory() {

	}

	/**
	 * Generates a new form based on the URI passed.
	 * 
	 * @return
	 */
	public static VerticalPanel generateNewForm(final EIEntity typeEntity) {
		return generateNewForm( typeEntity.getURI(), getNewFormRedisplay() );
	}

	public static VerticalPanel generateNewForm(final EIURI typeUri, final EditFormRedisplay redisplay) {
		final VerticalPanel vp = new VerticalPanel();

		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance( typeUri, new EIInstanceCallback() {
			@Override
			public void onSuccess(final EIInstance newInstance) {
				DataToolsBasicInstancePanel<OntologyPropertiesRenderer> formsPanel;
				formsPanel = EditFormsPanel.createNewForm( newInstance, ApplicationState.getInstance().getLabEntity(), redisplay );
				vp.add( formsPanel );
			}

			@Override
			public void loginRequired() {
				handleLoginRequired();
			}

			@Override
			public void onFailure(String error) {
				Window.alert( UIMessages.REPOSITORY_NOT_RESPONDING );
			}

		} );
		return vp;
	}

	/**
	 * This method creates a form to edit. The values of fields will be prepopulated.
	 * 
	 * @param eiuri
	 * @return
	 */
	public static DataToolsBasicInstancePanel<OntologyPropertiesRenderer> generateEditForm(final EIInstance instance) {
		return generateEditContents( instance );
	}

	public static VerticalPanel generateDuplicateForm(final EIInstance instance) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName( "formPanel" );
		final DataToolsBasicInstancePanel<OntologyPropertiesRenderer> formsPanel = EditFormsPanel.createNewForm( instance, ApplicationState.getInstance().getLabEntity(), getNewFormRedisplay() );
		vp.add( formsPanel );
		return vp;
	}

	public static VerticalPanel generateViewForm(final EIURI uri) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName( "formPanel" );
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance( uri, new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance instance) {
					vp.add( generateViewForm( instance ) );
				}

				@Override
				public void loginRequired() {
					handleLoginRequired();
				}

				@Override
				public void onFailure(String error) {
					Window.alert( UIMessages.NOT_IN_LIST );
				}
			} );
		} catch (final Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return vp;
	}

	@Deprecated
	public static VerticalPanel generateEditForm(final String eiuri) {
		return generateEditForm( EIURI.create( eiuri ) );
	}

	public static VerticalPanel generateEditForm(final EIURI uri) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName( "formPanel" );
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance( uri, new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance instance) {
					vp.add( generateEditContents( instance ) );
				}

				@Override
				public void loginRequired() {
					handleLoginRequired();
				}

				@Override
				public void onFailure(String error) {
					Window.alert( UIMessages.NOT_IN_LIST );
				}
			} );
		} catch (final Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return vp;
	}

	private static DataToolsBasicInstancePanel<OntologyPropertiesRenderer> generateEditContents(final EIInstance instance) {
		final DataToolsBasicInstancePanel<OntologyPropertiesRenderer> formsPanel = EditFormsPanel.createEditForm( instance, ApplicationState.getInstance().getLabEntity(), getEditFormRedisplay() );
		return formsPanel;
	}

	/**
	 * This method creates a form in 'view' mode. The fields are not editable
	 * 
	 * @param eiuri
	 * @return
	 */
	public static VerticalPanel generateViewForm(final EIInstance instance) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName( "formPanel" );
		final DataToolsBasicInstancePanel<OntologyPropertiesRenderer> formsPanel = new ViewFormsPanel( instance, getViewFormRedisplay() );
		vp.add( formsPanel );

		return vp;
	}

	private static void handleLoginRequired() {
		Window.alert( UIMessages.PLEASE_LOGIN );
	}

	protected static EditFormRedisplay getEditFormRedisplay() {
		return new EditFormRedisplay() {

			@Override
			public void drawAfterSave(final EIInstance instance) {
				// TODO: need a way to show a message!
				ApplicationState.getInstance().updateApplicationState( Mode.view, instance.getEntity(), instance.getInstanceType(), ApplicationState.getInstance().getLabEntity() );
				/*
				 * Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				 * 
				 * HTML msg = new HTML("<font color='green'>" + UIMessages.SAVE_SUCCESS + "</font>"); Datatools.showData(msg);// TODO: I don't like this here At All! try { ClientRepositoryToolsManager.INSTANCE.getInstance(instance .getInstanceURI(),
				 * new EIInstanceCallback() {
				 * 
				 * @Override public void onSuccess(EIInstance fetchedInstance) { viewAfterUpdate(fetchedInstance); }
				 * 
				 * @Override public void loginRequired() { handleLoginRequired(); } }); } catch (Exception e) { Log.error("could not (re-) get instance"); }
				 */
			}

			@Override
			public void drawAfterPromote(final EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At
				// All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance( instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(final EIInstance fetchedInstance) {
							generateEditForm( fetchedInstance );
						}

						@Override
						public void loginRequired() {
							handleLoginRequired();
						}

						@Override
						public void onFailure(String error) {
							Window.alert( UIMessages.NOT_IN_LIST );
						}
					} );
				} catch (final Exception e) {
					log.error( "could not (re-) get instance" );
				}
			}

			@Override
			public void drawAfterCancel(final EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance( instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(final EIInstance fetchedInstance) {
							viewAfterUpdate( fetchedInstance );
						}

						@Override
						public void loginRequired() {
							handleLoginRequired();
						}

						@Override
						public void onFailure(String error) {
							viewAfterUpdate( instance ); // TODO: correct?
						}
					} );
				} catch (final Exception e) {
					log.error( "could not (re-) get instance" );
				}

			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
				copyResource( instance.getInstanceURI() );
			}
		};
	}

	protected static ViewFormRedisplay getViewFormRedisplay() {
		return new ViewFormRedisplay() {

			@Override
			public void drawAfterPromote(final EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At
				// All!
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance( instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(final EIInstance fetchedInstance) {
							Datatools.showData( generateViewForm( fetchedInstance ) ); // TODO: any way to NOT do the showData part?
						}

						@Override
						public void loginRequired() {
							handleLoginRequired();
						}

						@Override
						public void onFailure(String error) {
							Window.alert( UIMessages.NOT_IN_LIST );
						}
					} );
				} catch (final Exception e) {
					log.error( "could not (re-) get instance" );
				}
			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
				copyResource( instance.getInstanceURI() );
			}

			@Override
			public void drawEdit(final EIInstance instance) {
				Datatools.clearDataPanel(); // TODO: I don't like this here At
				// All!
				Datatools.showData( generateEditForm( instance ) );
			}
		};
	}

	public static void copyResource(final EIURI instanceId) {
		ClientRepositoryToolsManager.INSTANCE.deepCopyInstance( instanceId, new EIInstanceCallback() {

			@Override
			public void loginRequired() {
				handleLoginRequired();
			}

			@Override
			public void onSuccess(final EIInstance eiInstance) {
				ApplicationState.getInstance().updateApplicationState( Mode.duplicate, eiInstance.getEntity(), eiInstance.getInstanceType(), Lab.getProperLabEntity( eiInstance ) );
				Datatools.showData( generateDuplicateForm( eiInstance ) );
				// Note: app state is set in a way that does NOT trigger a re-draw.  NOBODY else should use Mode.duplicate, or respond to it
			}

			@Override
			public void onFailure(String error) {
				Window.alert( UIMessages.DUPLICATION_FAILED );
			}
		} );
	}

	protected static EditFormRedisplay getNewFormRedisplay() {
		return new EditFormRedisplay() {

			@Override
			public void drawAfterSave(final EIInstance instance) {
				
				if ( Lab.isLabType( instance.getInstanceType() ) ) {
					log.debug( "updating lab cache" );
					ApplicationState.getInstance().updateLabCache();
					
				}
				
				EIEntity labEntity = Lab.getProperLabEntity( instance );
				ApplicationState.getInstance().updateApplicationState( Mode.view, instance.getEntity(), instance.getInstanceType(), labEntity );
				
			}

			@Override
			public void drawAfterPromote(final EIInstance instance) {
				Window.alert( "Cannot promote an unsaved new instance" );
			}

			@Override
			public void drawAfterCancel(final EIInstance instance) {
				Window.alert( "shouldn't get here (I think)" );
			}

			@Override
			public void drawAfterDuplicate(final EIInstance instance) {
				copyResource( instance.getInstanceURI() );
			}
		};
	}

	public static String getWFStateString(final EIInstance instance) {
		return instance.getWFState() == null ? "" : instance.getWFState().toString(); // TODO: make sure we need WFState() not
		// WFState().getURI()
	}

	public static void viewAfterSave(final boolean showSuccessMsg, final EIInstance instance) {
		Datatools.clearDataPanel(); // TODO: not here!
		if ( showSuccessMsg ) {
			final HTML msg = new HTML( "<font color='green'>" + UIMessages.SAVE_SUCCESS + "</font>" );
			Datatools.showData( msg );
		}

		ApplicationState.getInstance().updateApplicationState( Mode.view, instance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getLabEntity() );
	}

	public static void viewAfterUpdate(final EIInstance fetchedInstance) {
		ApplicationState.getInstance().updateApplicationState( Mode.view, fetchedInstance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getLabEntity() );
	}
}
