package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

public class Lab {

	public static boolean isLabType(final EIEntity entity) {
		return isLabType( entity.getURI() );
	}
	
	public static boolean isLabType(final EIURI range) {
		if ( range == null || range == EIURI.NULL_EIURI ) {
			return false;
		}
		return ( range.toString().equals( EagleIEntityConstants.EI_LAB ) || range.toString().equals( EagleIEntityConstants.EI_CORE_LAB ) );
	}
	
	public static EIEntity getProperLabEntity( EIInstance instance ) {
		return Lab.isLabType( instance.getInstanceType() ) ? instance.getEntity() : ApplicationState.getInstance().getLabEntity();
	}

}
