package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

/**
 * The top panel, header logo, sign in, etc
 */
public class TopPanel extends Composite implements ClientRepositoryToolsManager.SessionListener {

	private static final String BLANK = "_blank";

	interface Binder extends UiBinder<Widget, TopPanel> {
	}

	private static final Binder binder = GWT.create( Binder.class );

	@UiField
	protected Anchor changePassword;
	@UiField
	protected Image logo;
	@UiField
	protected Anchor searchLink;
	@UiField
	protected Anchor glossaryLink;
	@UiField
	protected Anchor helpLink;
	@UiField
	protected SpanElement institutionName;

	private boolean signedIn = false;
	public static String[] wfStates;
	public static Map<String, Boolean> accessMap = new HashMap<String, Boolean>();

	private Map<String, String> shortNameToFullNameMap = new HashMap<String, String>() {
		{
			put( "harvard", "Harvard University" );
			put( "upr", "University Of Puerto Rico Medical Sciences Campus" );
			put( "msm", "Morehouse School of Medicine" );
			put( "jsu", "Jackson State University" );
			put( "hawaii", "University of Hawaii at Manoa" );
			put( "ohsu", "Oregon Health & Science University" );
			put( "dartmouth", "Dartmouth College" );
			put( "montana", "Montana State University" );
			put( "alaska", "University of Alaska Fairbanks" );
		}
	};

	public TopPanel() {
		initWidget( binder.createAndBindUi( this ) );

		if ( !signedIn ) {

			changePassword.setVisible( false );
		}
		searchLink.setHref( getSearchURL() == null ? "http://search.eagle-i.net/central/" : getSearchURL() );
		searchLink.setTarget( BLANK );
		glossaryLink.setHref( WidgetUtils.getGlossaryURL() == null ? "http://search.eagle-i.net/model/" : WidgetUtils.getGlossaryURL() );
		glossaryLink.setTarget( BLANK );
		helpLink.addClickHandler( new ClickHandler() {

			public void onClick(final ClickEvent clickEvent) {
				Window.open( WidgetUtils.getHelpURL(), BLANK, "height=" + ( getHelpWindowHeight() ) + ",width=" + getHelpWindowWidth() + ",left=" + ( getHelpWindowLeft() ) + ",top=0" );
			}
		} );
		final String shortName = WidgetUtils.getNodeNameFromURL();
		logo.setUrl( "images/" + shortName + "_logo.png" );
		institutionName.setInnerText( shortNameToFullNameMap.get( shortName ) );

		changePassword.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {

				if ( signedIn ) {
					Window.open( WidgetUtils.getChangePasswordURL(), BLANK, "height=" + ( getHelpWindowHeight() ) + ",width=" + getHelpWindowWidth() + ",left=" + ( getHelpWindowLeft() ) + ",top=0" );
				}
			}
		} );
		if ( DatatoolsCookies.hasSession() ) {
			signedIn = true;
		}
		ClientRepositoryToolsManager.INSTANCE.addSessionListener( this );
	}

	private void performLogout() {
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	@Override
	public void onLogOut() {
		changePassword.setVisible( false );
		signedIn = false;
		
	}

	@Override
	public void onLogIn(final String username, final String userUri) {
		changePassword.setVisible( true );
		signedIn = true;
	}

	private String getSearchURL() {
		final String url = GWT.getHostPageBaseURL();
		final String node = WidgetUtils.getNodeNameFromURL();
		if ( node != null ) {
			final String searchUrl = url.replace( node + ".", "search." ).replace( "/datatools/", "" ) + "/central/";
			return searchUrl;
		} else {
			return null;
		}
	}

	private int getHelpWindowHeight() {
		return Window.getClientHeight() + Window.getClientHeight() / 12;
	}

	private int getHelpWindowWidth() {
		return 600;
	}

	private int getHelpWindowLeft() {
		return Window.getClientWidth() - getHelpWindowWidth();
	}
}
