package org.eaglei.datatools.client.ui;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Displays the Form for viewing. All the fields are disabled and no editing is possible.
 * 
 */
public class ViewFormsPanel extends DatatoolsInstancePanel {

	private static final GWTLogger log = GWTLogger.getLogger( "ViewFormsPanel" );

	public ViewFormsPanel(final EIInstance instance, final ViewFormRedisplay redisplay) {
		super( instance, redisplay );
		ontologyPropRenderer = new OntologyPropViewRenderer(eiInstance, ontologyPanel);
		shouldShowReadOnlyProperties = true;
	}

	@Override
	protected void drawNonOntologyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final VerticalPanel nonOntologyPanel) {
		final String propLabel = propertyEntity.getLabel();
		final LabelValuesWidget widget = new LabelValuesWidget( propLabel );
		for (final String value : propertyValues) {
			widget.add( handleReadOnlyTextProperty( value ) );
		}
		nonOntologyPanel.add( widget );
	}

	@Override
	protected void drawNonOntologyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final VerticalPanel nonOntologyPanel) {
		final String propLabel = propertyEntity.getLabel();
		final LabelValuesWidget widget = new LabelValuesWidget( propLabel );
		boolean hadValue = false;
		for (final EIEntity propEntity : propertyValues) {
			// Not sure if it's possible to delete the referred-to entity for a non-ontology literal, but we might as well take care of it...
			if ( propEntity != null && propEntity != EIEntity.NULL_ENTITY && !propEntity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				widget.add( handleReadOnlyTextProperty( propEntity.getLabel() ) );
				hadValue = true;
			}
		}
		if ( hadValue ) {
			nonOntologyPanel.add( widget );
		}
	}

	
	@Override
	protected void drawReferencedBy() {
		final Anchor referencedBy = new Anchor( "Referenced by..." );
		referencedBy.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent arg0) {
				log.info( "trying to get references for " + eiInstance );
				ApplicationState.getInstance().updateApplicationState( Mode.references, eiInstance.getEntity(), EIEntity.NULL_ENTITY, ApplicationState.getInstance().getLabEntity() );
			}

		} );
		final HorizontalPanel referencePanel = new HorizontalPanel();
		referencePanel.add( referencedBy );
		referencedBy.setStyleName( "referencedBy" );
		formPanel.add( referencePanel );
	}


	@Override
	protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	protected void drawExtraFields(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		// deliberate no-op
	}

	@Override
	protected void setButtonState() {
		buttonPanel.saveButton.setVisible( false );
		buttonPanel.copyResourceButton.setVisible( true );
		buttonPanel.cancelButton.setVisible( false );
		// buttonPanel.editButton.setVisible(true);
		buttonPanel.editButton.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().setMode( Mode.edit ); // TODO: anything else we need to set here?
			}
		} );

	}
}
