package org.eaglei.datatools.client.ui.widgets;

import java.util.List;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.MinimalEIInstancesCallback;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;

public class EIResourceListWidget extends EditWidget {

	private static final String CREATE_NEW_VALUE = "<create new>";
	private static final String NO_VALUE = "<none>";
	private final ListBox instances = new ListBox();
	private final EIClass range;
	private final boolean shouldHaveLabel;
	private final boolean isPropertyLabRelated;
	private final NewInnerInstanceListener listener;
	private final FlowPanel valuePanel;
	private StubWidget stubWidget;
	private Anchor allLabsAnchor;
	private Label stubMessage;
	//FIXME hack to get spacing after label; undo once we can style
	private static String FROM_ALL_LABS_LABEL = "See choices from all labs.  ";
	private static String FROM_ONLY_CURRENT_LAB = "Restrict to choices from this lab.  ";
	private final Anchor changeLabLink;
	private static final String CHANGE_LABS = "Change lab.";

	private static GWTLogger log = GWTLogger.getLogger( "EIResourceListWidget" );

	public EIResourceListWidget(final EIInstance instance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedEntity, final boolean shouldShowLabel,
			final boolean isPropertyLabRelated, final NewInnerInstanceListener listener) {

		super( instance, propertyEntity, propertyDefinition, isRequired,Layout.Horizontal );

		this.range = range;
		this.listener = listener;

		if ( selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY ) {
			oldValue = selectedEntity.getURI().toString();
			if ( selectedEntity.getLabel().equals( "" ) || selectedEntity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				selectedEntity.setLabel( selectedEntity.getURI().toString() );
			}
		}
		shouldHaveLabel = shouldShowLabel;
		if ( !shouldHaveLabel ) {
			widgetPanel.remove( label );
		}
		
		this.isPropertyLabRelated = isPropertyLabRelated;

		valuePanel = new FlowPanel();
		valuePanel.setStyleName("ResourceListPanel");
		widgetPanel.add( valuePanel );
		changeLabLink = new Anchor(CHANGE_LABS);
		stubMessage = new Label(UIMessages.STUB_TO_BE_COMPLETED);
		stubMessage.setStyleName("commentOnComments");
		setup();

		intializeInstances();
	}

	private void intializeInstances() {

		instances.setStyleName( "formDropdown" );
		addDefaultInstanceValues();
		if ( range.equals( EIClass.NULL_CLASS ) ) {
			log.info( "skipping get instances" );
			if ( hasOldValue() ) {
				instances.removeItem( instances.getItemCount() - 1 );
				final String probablyDeletedLabel = "[non-standard link] " + getOldStringValue();
				instances.addItem( probablyDeletedLabel, getOldStringValue() );
				instances.setSelectedIndex( instances.getItemCount() - 1 );
			}
		} else {

			if ( !isInLab() ) {
				// fill the instance list with all the resources if not in lab
				fillListBoxWithResources( false, EIURI.NULL_EIURI );
			} else {
				// fill the instances list with resources from current lab if in lab
				fillListBoxWithResources( true, ApplicationState.getInstance().getLabUri() );
			}
		}

		instances.addChangeHandler( new ChangeHandler() {
			@Override
			public void onChange(final ChangeEvent arg0) {
				doOnChange( eiInstance, range, propertyEntity, oldValue, instances );
			}
		} );
	}

	/**
	 *loads the list box with the resources
	 * 
	 * @param boolean onlyFromThisLab if this value is passed true then it only loads the resources from the current lab
	 *@param labEIURI
	 *            if user click "From All labs" this is passed NULL_EIURI otherwise its passed with lab uri
	 * 
	 */
	private void fillListBoxWithResources(final boolean onlyFromThisLab, final EIURI labEIURI) {
		try {
			instances.clear();
			instances.addItem( "...loading...", null );

			log.debug( "requesting resource list for " + range.getEntity().getURI() );

			// TODO refine state
			// Note that the boolean is combined with "is this a lab range" (because labs are not associated to labs, but they need to show for lab property to be set)
			ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue( range.getEntity().getURI(), labEIURI, EIURI.NULL_EIURI, !isPropertyLabRelated && onlyFromThisLab, new MinimalEIInstancesCallback() {
				public void onSuccess(final List<EIInstanceMinimal> result) {

					if ( hasOldValue() && onlyFromThisLab && oldValueMissingFromResult( result ) ) {
						//instances.clear();
						//instances.addItem( "...loading...", null );
						try {
							ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue( range.getEntity().getURI(), labEIURI, EIURI.NULL_EIURI, false, new MinimalEIInstancesCallback() {
								public void onSuccess(final List<EIInstanceMinimal> result) {
									setInstancesAndPickLists( false, result );
									allLabsAnchor.setText( FROM_ONLY_CURRENT_LAB );
									allLabsAnchor.setVisible( false );
								}

								@Override
								public void loginRequired() {
									// handleLoginRequired();
								}

								@Override
								public void onFailure(String error) {
									Window.alert( UIMessages.COULD_NOT_FIND_RESOURCES_MESSAGE );
								}
							} );
						} catch (Exception e) {
							// TODO Auto-generated catch block
							log.error( e.getMessage() );
						}
					}

					setInstancesAndPickLists( onlyFromThisLab, result );
				}

				@Override
				public void loginRequired() {
					// handleLoginRequired();
				}

				@Override
				public void onFailure(String error) {
					Window.alert( UIMessages.COULD_NOT_FIND_RESOURCES_MESSAGE );
				}
			} );
		} catch (final Exception e) {
			log.error( e.getMessage() );
			// TODO do something intelligent
		}
	}
	
	private void setInstancesAndPickLists(final boolean onlyFromThisLab, final List<EIInstanceMinimal> result) {
		instances.clear();
		instances.addItem( NO_VALUE, null );
		instances.addItem( CREATE_NEW_VALUE, null );
		// Move resources with current lab to beginning of the list ONLY if the list contains resources from all
		if ( !onlyFromThisLab && ApplicationState.getInstance().hasLab() ) {
			for (int i = 0, j = result.size() - 1; i < result.size(); i++) {
				if ( result.get( j ).getLab().equals( ApplicationState.getInstance().getLabEntity() ) ) {
					result.add( 0, result.remove( j ) );
				} else {
					j--;
				}
			}
		}
		for (final EIInstanceMinimal instance : result) {
			instances.addItem( formatInstanceForListBox( instance ), instance.getInstanceURI().toString() );
			if ( ApplicationState.getInstance().hasLab() && instance.getLab().equals( ApplicationState.getInstance().getLabEntity() ) ) {
				final Element childElement = (Element)instances.getElement().getChild( instances.getItemCount() - 1 );
				childElement.setClassName( "ownlabTxt" );
			}
			if ( instance.getInstanceURI().toString().equals( oldValue ) ) {
				instances.setSelectedIndex( instances.getItemCount() - 1 );
			}
		}
	}

	private boolean oldValueMissingFromResult(List<EIInstanceMinimal> fetchedInstances) {
		final EIURI oldUri = EIURI.create(oldValue);
		
		for ( EIInstanceMinimal instance : fetchedInstances ) {
			if ( instance.getInstanceURI().equals(oldUri) ) {
				return false;
			}
		}
		
		return true;
	}

	private void addDefaultInstanceValues() {
		instances.addItem( NO_VALUE, null );
		instances.addItem( CREATE_NEW_VALUE, null );
		instances.addItem( "...loading...", null );
	}

	private void doOnChange(final EIInstance instance, final EIClass range, final EIEntity propertyEntity, final String propertyValue, final ListBox subClassList) {
		if ( subClassList.getItemText( subClassList.getSelectedIndex() ).equals( NO_VALUE ) ) {
			removeValue();
			if( stubWidget != null ) {
				valuePanel.remove( stubMessage );
				listener.onInstanceRemoved( stubWidget.getEIInstance() );
			}
			allLabsAnchor.setVisible( true );
		} else if ( subClassList.getItemText( subClassList.getSelectedIndex() ).equals( CREATE_NEW_VALUE ) ) {

			ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance( range.getEntity().getURI(), new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance newInstance) {
					listener.onInstanceAdded( newInstance );

					newInstance.addNonOntologyLiteralProperty( DatatoolsUIConstants.isStubEntity, "True" ); // TODO: boolean value: is this right?
					stubWidget = new StubWidget( newInstance, propertyEntity, range, propertyValue, true );
					if ( hasOldValue() ) {
						eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), newInstance.getEntity() );
					} else {
						eiInstance.addObjectProperty( propertyEntity, newInstance.getEntity() );
					}
					updateOldValue( newInstance.getInstanceURI() );
					allLabsAnchor.setVisible( false );
					valuePanel.add(stubMessage);
					valuePanel.add( stubWidget );
				}

				@Override
				public void loginRequired() {
					// handleLoginRequired();
				}

				@Override
				public void onFailure(String error) {
					Window.alert( UIMessages.REPOSITORY_NOT_RESPONDING );
				}
			} );

			// }
		} else {
			allLabsAnchor.setVisible( true );
			if ( stubWidget != null ) {
				listener.onInstanceRemoved( stubWidget.getEIInstance() );
				valuePanel.remove( stubWidget );

			}
			
			// FIXME total hack for DTOOLS-762: if we're displaying all resources (the toggle message says only current lab), hide the link
			// ideally we do this with information about whether the selected item is in fact from the current lab or some other, but not the day of the release
			if ( allLabsAnchor.getText().equals(FROM_ONLY_CURRENT_LAB) ) {
				allLabsAnchor.setVisible( false );
			}
			
			if ( hasOldValue() ) {
				eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), WidgetUtils.getSelectedEntity( subClassList ) );
			} else {
				eiInstance.addObjectProperty( propertyEntity, WidgetUtils.getSelectedEntity( subClassList ) );
			}
			updateOldValue( WidgetUtils.getSelectedUri( subClassList ) );
		}

	}

	private void setup() {
		//HorizontalPanel innerHoriz = new HorizontalPanel();
		//flowPanel.add( innerHoriz );

		instances.setName( propertyEntity.getURI().toString() + "_instances" );
		valuePanel.add( instances );
		allLabsAnchor = new Anchor( FROM_ALL_LABS_LABEL );

		allLabsAnchor.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				fillResourceListAndToggle();
			}
		} );

		if ( isInLab() ) {
			valuePanel.add( allLabsAnchor );
		}

	}

	private boolean isInLab() {
		if ( ApplicationState.getInstance().hasLab() ) {
			return true;

		} else {
			return false;
		}
	}

	private void fillResourceListAndToggle() {
		if ( allLabsAnchor.getText().equals( FROM_ALL_LABS_LABEL ) ) {
			fillListBoxWithResources( false, EIURI.NULL_EIURI );
			allLabsAnchor.setText( FROM_ONLY_CURRENT_LAB );
		} else {
			fillListBoxWithResources( true, ApplicationState.getInstance().getLabUri() );
			allLabsAnchor.setText( FROM_ALL_LABS_LABEL );
		}
	}

	private String formatInstanceForListBox(final EIInstanceMinimal valueInstance) {
		return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">" + ( !valueInstance.getLab().equals( EIEntity.NULL_ENTITY ) ? ", " + valueInstance.getLab().getLabel() : "" );
	}

	@Override
	public EditWidget duplicateBlank() {
		return new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, (EIEntity)null, true, isPropertyLabRelated, listener );
	}

	@Override
	protected void removeValue() {
		if ( hasOldValue() ) {
			if ( stubWidget != null ) {
				valuePanel.remove( stubWidget );
			}
			eiInstance.replaceObjectPropertyValue( propertyEntity, getOldEIURIValue(), null );
			oldValue = null;
		}

	}

	public void disableAsLabProperty() {
		instances.setEnabled( false );
		allLabsAnchor.setVisible( false ); 
		if ( ApplicationState.getInstance().getMode() == Mode.duplicate ) {
			valuePanel.remove(allLabsAnchor);
			valuePanel.add(changeLabLink);
			changeLabLink.addClickHandler( new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					instances.setEnabled( true );
					valuePanel.remove(changeLabLink);
					valuePanel.add( allLabsAnchor );
					allLabsAnchor.setVisible( false );
				}
			});
		}
	}

}
