package org.eaglei.datatools.client.ui.widgets;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class EditWidgetCollection extends Composite {
	// TODO: style the vertical panel
	protected VerticalPanel widgetPanel = new VerticalPanel();
	protected List<EditWidget> editWidgets = new ArrayList<EditWidget>();

	protected EIInstance eiInstance;
	protected EIEntity propertyEntity;

	public EditWidgetCollection(final EIInstance eiInstance, final EIEntity propertyEntity) {
		initWidget( widgetPanel );
		this.eiInstance = eiInstance;
		this.propertyEntity = propertyEntity;
	}

	public EditWidgetCollection(final EIInstance eiInstance, final EIEntity propertyEntity, final EditWidget original) {
		this( eiInstance, propertyEntity );
		addWidget( original );
	}

	public void addWithoutModifiers(final Widget radioButtonWidget) {
		widgetPanel.add( radioButtonWidget );
	}

	public void addWidget(final EditWidget newWidget) {
		addWidget( newWidget, false );
	}

	public void addWidget(final EditWidget newWidget, final boolean skipPlusMinus) {
		final HorizontalPanel widgetWithDecorator = new HorizontalPanel();
		editWidgets.add( newWidget );
		widgetWithDecorator.add( newWidget );
		widgetPanel.add( widgetWithDecorator );
		if ( skipPlusMinus ) {
			return;
		}
		if ( editWidgets.size() == 1 ) {
			// Log.info("adding " + newWidget.getClass().getName() + " with plus");
			final Label addField = new Label( "+" );
			addField.setStyleName("liveLink");
			widgetWithDecorator.add( addField );
			newWidget.setShouldShowLabel( true );
			addField.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(final ClickEvent event) {
					addWidget( newWidget.duplicateBlank() );
				}
			} );
		} else {
			final Label minusField = new Label( "-" );
			minusField.setStyleName("liveLink");
			widgetWithDecorator.add( minusField );
			newWidget.setShouldShowLabel( false );
			minusField.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(final ClickEvent event) {
					newWidget.removeValue();
					widgetPanel.remove( widgetWithDecorator );
					editWidgets.remove( newWidget );
					minusField.removeFromParent();
				}
			} );
		}
	}
}
