package org.eaglei.datatools.client.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.DatatoolsClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIClassesCallback;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class ObjectWidget extends EditWidget {

	private final ListBox rangePicker = new ListBox();
	private List<EIClass> rangeList = new ArrayList<EIClass>();
	private final EIEntity selectedEntity;
	private EIClass instanceRootClass;
	private List<EIClass> instanceSuperclasses;
	private EditWidget innerWidget;
	private final EIEntity labEntity;
	private boolean isEnabled = true;
	private final NewInnerInstanceListener listener;
	private final boolean isPropertyLabRelated;

	private final Map<EIEntity, EIClass> entityRangeMap = new HashMap<EIEntity, EIClass>();

	private static final String NO_VALUE = "<none>";

	private static final GWTLogger log = GWTLogger.getLogger( "ObjectWidget" );

	public ObjectWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final List<EIClass> rangeList, final EIEntity labEntity, final EIEntity selectedEntity,
			final boolean isPropertyLabRelated, final NewInnerInstanceListener listener) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired,Layout.Horizontal);
		log.debug( "range list has " + rangeList.size() + " entries" );
		this.rangeList = rangeList;
		Collections.sort( this.rangeList, new Comparator<EIClass>() {

			@Override
			public int compare(EIClass arg0, EIClass arg1) {
				return arg0.getEntity().getLabel().compareTo( arg1.getEntity().getLabel() );
			}

		} );
		this.listener = listener;
		this.selectedEntity = selectedEntity;
		this.isPropertyLabRelated = isPropertyLabRelated;
		log.debug( "selected entity is: " + this.selectedEntity );
		this.labEntity = labEntity;

		getInstanceRootClass();

	}

	private void setup() {
		rangePicker.setStyleName( "MultiRangeDropbox" );
		widgetPanel.add( rangePicker );
		rangePicker.addItem( NO_VALUE, NO_VALUE );

		for (final EIClass range : rangeList) {
			entityRangeMap.put( range.getEntity(), range );
			rangePicker.addItem( range.getEntity().getLabel(), range.getEntity().getURI().toString() );
			// FIXME instanceRootSuperClass may be way up in the hierarchy, and range may be more specific
			// but a child; this should return true in such cases.
			if ( instanceRootClass == null && instanceSuperclasses != null && instanceSuperclasses.contains( range ) ) {
				rangePicker.setSelectedIndex( rangePicker.getItemCount() - 1 );
			} else if ( instanceRootClass != null && range.getEntity().equals( instanceRootClass.getEntity() ) ) {
				rangePicker.setSelectedIndex( rangePicker.getItemCount() - 1 );
			} else if ( hasLabUri() && InstanceWidgetUtils.isLabProperty( range ) ) {
				rangePicker.setSelectedIndex( rangePicker.getItemCount() - 1 );
			}
		}

		selectProperValue();

		setRangePickBehavior();
	}

	private void setRangePickBehavior() {
		rangePicker.addChangeHandler( new ChangeHandler() {
			@Override
			public void onChange(final ChangeEvent arg0) {
				if ( rangePicker.getItemText( rangePicker.getSelectedIndex() ).equals( NO_VALUE ) ) {
					if ( hasOldValue() ) {
						removeValue();
					}
					if ( widgetPanel.getWidgetCount() > 2 ) {
						widgetPanel.remove( 2 );
						innerWidget = null;
					}
				} else {
					if ( widgetPanel.getWidgetCount() > 2 ) {
						if ( getInnerWidget().hasOldValue() ) {
							eiInstance.replaceObjectPropertyValue( propertyEntity, getInnerWidget().getOldEIURIValue(), null );
						}
						widgetPanel.remove( 2 );
						innerWidget = null;
					}
					final EIEntity selectedRange = getSelectedRangeEntity();
					updateOldValue( selectedRange.getURI() ); // this is how it used to be
					EIClass selectedRangeClass = entityRangeMap.get( selectedRange );
					if ( selectedRangeClass.isEagleIResource() ) {
						innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, entityRangeMap.get( selectedRange ), EIEntity.NULL_ENTITY, false, isPropertyLabRelated, listener );
						widgetPanel.add( innerWidget );
						if ( InstanceWidgetUtils.isLabProperty( selectedRangeClass ) ) {
							( (EIResourceListWidget)innerWidget ).disableAsLabProperty();
						}
					} else {
						final EIClass range = entityRangeMap.get( selectedRange );
						log.debug( "term widget: selected range " + range );
						final HorizontalPanel tempPanel = new HorizontalPanel();
						widgetPanel.add( tempPanel );
						// TODO: inner callback to set the inner panel to the term widget created this way
						WidgetUtils.addTermWidgetToPanel( eiInstance, propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, tempPanel, false );
					}
				}
			}
		} );
	}

	private void selectProperValue() {
		if ( rangePicker.getSelectedIndex() > 0 ) {
			final EIEntity selectedRange = getSelectedRangeEntity();
			if ( entityRangeMap.get( selectedRange ).isEagleIResource() ) {
				if ( ( selectedEntity == null ) && hasLabUri() && isPropertyLabRelated ) {
					log.info( "making lab-property for " + entityRangeMap.get( selectedRange ) + " " + labEntity );
					eiInstance.addObjectProperty( propertyEntity, labEntity );
					innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, entityRangeMap.get( selectedRange ), labEntity, false, isPropertyLabRelated, listener );
					disable();
				} else {
					innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, entityRangeMap.get( selectedRange ), selectedEntity, false, isPropertyLabRelated, listener );
					if ( hasLabUri() && isPropertyLabRelated ) {
						disable();
					}
				}
				widgetPanel.add( innerWidget );
			} else {
				final HorizontalPanel tempPanel = new HorizontalPanel();
				widgetPanel.add( tempPanel );
				WidgetUtils.addTermWidgetToPanel( eiInstance, propertyEntity, propertyDefinition, isRequired, instanceRootClass, selectedEntity, tempPanel, false );
			}

		} else if ( selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY ) {
			log.info( "trying to make widget for deleted value" );
			innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, EIClass.NULL_CLASS, selectedEntity, false, isPropertyLabRelated, listener );
			widgetPanel.add( innerWidget );
		}
	}

	private void getInstanceRootClass() {
		if ( selectedEntity == null ) {
			log.info( "no selected entity" );
			setup();
			return;
		}

		if ( WidgetUtils.isInstance( selectedEntity ) ) {

			log.debug( "Trying to get superclasses for instance: " + selectedEntity );
			ClientRepositoryToolsManager.INSTANCE.getClassAndSuperclassesForInstanceUri( selectedEntity.getURI(), new EIClassesCallback() {

				@Override
				public void onSuccess(final List<EIClass> result) {
					instanceSuperclasses = result;
					log.debug( "Got superclasses: " + instanceSuperclasses );
					setup();
				}

				@Override
				public void onFailure(final String result) {
					// instanceSuperclasses = new ArrayList<EIClass>();

					log.warn( "Server call getRootSuperclassForInstanceUri failed; instance may have been deleted" );
					setup();
				}

			} );
		} else {
			log.debug( "in getInstanceRootClass for " + selectedEntity );
			ClientModelManager.INSTANCE.getClass( selectedEntity.getURI(), new ClassCallback() {

				@Override
				public void onSuccess(final EIClass result) {
					ClientRepositoryToolsManager.INSTANCE.getRootSuperClass( result, new DatatoolsClassCallback() {
						@Override
						public void onSuccess(final EIClass superclass) {
							instanceRootClass = superclass;
							setup();
						}

						@Override
						public void onFailure(String error) {
							// TODO Auto-generated method stub

						}

					} );
				}
			} );
		}
	}

	private EIEntity getSelectedRangeEntity() {
		return WidgetUtils.getSelectedEntity( rangePicker );
	}

	protected EditWidget getInnerWidget() {
		if ( innerWidget != null ) {
			return innerWidget;
		} else if ( widgetPanel.getWidgetCount() > 2 ) {
			Widget widget = widgetPanel.getWidget( 2 );
			if ( widget instanceof HorizontalPanel ) {
				widget = ( (HorizontalPanel)widget ).getWidget( 0 );
				if ( widget != null ) {
					return (EditWidget)widget;
				}
			}

			if ( widget instanceof EditWidget ) {
				final EditWidget inner = ( (EditWidget)widget );
				return inner;
			} else {
				Window.alert( "Failed to get an editWidget" ); // TODO: remove
			}
		}

		return null;
	}

	@Override
	protected boolean hasOldValue() {
		if (getInnerWidget() == null) {
			return false;
		}
		return getInnerWidget().hasOldValue();
	}

	@Override
	protected void removeValue() {
		if ( getInnerWidget() == null ) {
			return;
		}
		getInnerWidget().removeValue();
	}

	@Override
	public EditWidget duplicateBlank() {
		return new ObjectWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, rangeList, labEntity, null, isPropertyLabRelated, listener );
	}

	// TODO: make static in WidgetUtils
	protected boolean hasLabUri() {
		return ( labEntity != null ) && ( !labEntity.getURI().toString().equals( "" ) );
	}

	public void disable() {
		rangePicker.setEnabled( false );
		if ( innerWidget instanceof EIResourceListWidget ) {
			( (EIResourceListWidget)innerWidget ).disableAsLabProperty();
		}
		isEnabled = false;
	}

	public boolean isDisabled() {
		return !isEnabled;
	}
}
