package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

public class OldValueHandlerFactory {

	public static OldValueHandler getDatatypeOldValueHandler() {
		return new OldValueHandler() {

			@Override
			public void replaceValue(final EIInstance instance, final EIEntity propertyEntity, final String oldValue, final String newValue) {
				instance.replaceDatatypePropertyValue( propertyEntity, oldValue, newValue );

			}

			@Override
			public void addValue(final EIInstance instance, final EIEntity propertyEntity, final String newValue) {
				instance.addDatattypeProperty( propertyEntity, newValue );

			}

		};
	}

	public static OldValueHandler getNonOntologyOldValueHandler() {
		return new OldValueHandler() {

			@Override
			public void replaceValue(final EIInstance instance, final EIEntity propertyEntity, final String oldValue, final String newValue) {
				instance.replaceNonOntologyLiteralProperty( propertyEntity, oldValue, newValue );

			}

			@Override
			public void addValue(final EIInstance instance, final EIEntity propertyEntity, final String newValue) {
				instance.addNonOntologyLiteralProperty( propertyEntity, newValue );

			}
		};
	}
}
