/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DataToolsBasicInstancePanel;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.OntologyPropertiesRenderer;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public abstract class DatatoolsInstancePanel
extends DataToolsBasicInstancePanel<OntologyPropertiesRenderer> {
    protected FormRedisplay redisplayCallbacks;
    protected ButtonsPanel buttonPanel;

    protected abstract void setButtonState();

    protected abstract void drawNonOntologyLiteralProperty(EIEntity var1, Set<String> var2, VerticalPanel var3);

    protected abstract void drawNonOntologyResourceProperty(EIEntity var1, Set<EIEntity> var2, VerticalPanel var3);

    public DatatoolsInstancePanel(EIInstance instance, FormRedisplay redisplay) {
        this.redisplayCallbacks = redisplay;
        this.eiInstance = instance;
        this.initializeSpecifics();
    }

    protected void initializeSpecifics() {
        this.buttonPanel = new ButtonsPanel(this.eiInstance, this.redisplayCallbacks);
        this.outerFormPanel.add((Widget)this.buttonPanel);
        this.buttonPanel.copyResourceButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setButtonState();
        super.initializeSpecifics();
    }

    protected void drawAdminProperties() {
        DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
        Map instanceNonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        Map instanceNonOntologyResourceProperties = this.eiInstance.getNonOntologyResourceProperties();
        ArrayList entityList = new ArrayList();
        entityList.addAll(this.eiInstance.getReadOnlyLiteralProperties().keySet());
        entityList.addAll(this.eiInstance.getReadOnlyResourceProperties().keySet());
        entityList.addAll(instanceNonOntologyLiteralProperties.keySet());
        entityList.addAll(instanceNonOntologyResourceProperties.keySet());
        VerticalPanel innerPanel = new VerticalPanel();
        this.createNonOntologyPanel(instanceNonOntologyLiteralProperties, instanceNonOntologyResourceProperties, innerPanel);
        nonOntologyPanel.add((Widget)innerPanel);
        this.formPanel.add((Widget)nonOntologyPanel);
    }

    protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties, Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, VerticalPanel innerPanel) {
        VerticalPanel metaPanel = new VerticalPanel();
        VerticalPanel otherPanel = new VerticalPanel();
        this.designPanel(metaPanel, "Metadata properties:");
        this.designPanel(otherPanel, "Other properties:");
        LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
        Anchor id = new Anchor(this.eiInstance.getInstanceURI().toString(), this.eiInstance.getInstanceURI().toString(), "_blank");
        eagleIUniqueId.add((Widget)id);
        innerPanel.add((Widget)eagleIUniqueId);
        if (this.shouldShowReadOnlyProperties) {
            innerPanel.add((Widget)metaPanel);
            innerPanel.add((Widget)otherPanel);
            Map readOnlyLiterals = this.eiInstance.getReadOnlyLiteralProperties();
            Map readOnlyResources = this.eiInstance.getReadOnlyResourceProperties();
            this.drawReadOnlyProperties(null, metaPanel, readOnlyLiterals, readOnlyResources);
        }
        VerticalPanel panelToUse = this.shouldShowReadOnlyProperties ? otherPanel : innerPanel;
        for (EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
            this.drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), panelToUse);
        }
        for (EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
            this.drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), panelToUse);
        }
    }

    private void drawReadOnlyProperties(Map<EIEntity, String> labelMap, VerticalPanel metaPanel, Map<EIEntity, String> readOnlyLiterals, Map<EIEntity, EIEntity> readOnlyResources) {
        for (EIEntity propEntity : readOnlyLiterals.keySet()) {
            this.drawReadOnlyLiteralProperty(propEntity, (Set)this.makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);
        }
        for (EIEntity propEntity : readOnlyResources.keySet()) {
            this.drawReadOnlyResourceProperty(propEntity, (Set)this.makeSetFromSingleEntity(readOnlyResources.get(propEntity)), labelMap, metaPanel);
        }
    }

    private void designPanel(VerticalPanel panel, String header) {
        panel.setStyleName("formPanel");
        Label propHeader = new Label(header);
        propHeader.setStyleName("nonOntologyPropertyLabel");
        panel.add((Widget)propHeader);
    }
}

