/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.Lab;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.Performable;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.datatools.client.ui.listeners.RowDeletionListener;
import org.eaglei.datatools.client.ui.widgets.EIConfirmationPopup;
import org.eaglei.datatools.client.ui.widgets.GridRowWidget;
import org.eaglei.datatools.client.ui.widgets.PaginationWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;

public class EIResourcesGrid
extends Composite
implements RowDeletionListener {
    private static final String GRID_ROW_COLUMN_HEADER = "gridRowColumnHeader";
    private static final String[] RESOURCE_COLUMN_NAMES = SortByProperties.getColumnNames();
    private static final Map<String, Comparator<EIInstanceMinimal>> resourceSorters = new HashMap();
    public static final String DATATOOLS_FILTER = "DatatoolsFilter";
    private List<EIInstanceMinimal> instances = new ArrayList();
    private final Map<EIInstanceMinimal, GridRowWidget> instanceRowMap = new HashMap();
    private final Map<String, WorkFlowTransition> actionTransitionMap = new HashMap();
    private FilterPanel filterPanel;
    private final FlowPanel resources = new FlowPanel();
    private final FlowPanel innerPanel = new FlowPanel();
    private PaginationWidget paginationWidget;
    private final FlowPanel nonGridContentPanel = new FlowPanel();
    private final FlowPanel pageHeaderPanel = new FlowPanel();
    private final FlowPanel subPageHeaderPanel = new FlowPanel();
    private static final GWTLogger log = GWTLogger.getLogger((String)"EIResourcesGrid");

    public EIResourcesGrid() {
        this.initialize();
        this.drawFromApplicationState();
    }

    public EIResourcesGrid(List<EIInstanceMinimal> instances) {
        log.info("Creating grid with " + instances.size() + " instances");
        this.instances = instances;
        this.initialize();
        log.info("Creating pagination widget");
        this.paginationWidget = new PaginationWidget(ApplicationState.getInstance().getOffset(), Integer.valueOf(instances.size()), ApplicationState.getInstance().getLimit());
        this.resources.remove((Widget)this.nonGridContentPanel);
        this.drawFromApplicationState();
    }

    private void initialize() {
        this.initWidget((Widget)this.innerPanel);
        if (resourceSorters.size() == 0) {
            this.initializeSorters();
        }
        this.filterPanel = new FilterPanel(ApplicationState.getInstance().hasFilterTypeEntity() ? ApplicationState.getInstance().getFilterTypeEntity() : ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getFilterWorkflowEntity(), ApplicationState.getInstance().getFilterLabEntity(), ApplicationState.getInstance().isStrictlyFilteredByOwner());
        this.resources.getElement().setClassName("listGrid");
        Label pageHeaderLabel = this.getHeaderLabel();
        for (WorkFlowTransition transition : ClientRepositoryToolsManager.INSTANCE.getAllowedTransitions()) {
            if (!this.isUsefulTransition(transition)) continue;
            this.actionTransitionMap.put(this.getName(transition), transition);
        }
        this.subPageHeaderPanel.setStyleName("pageHeaderContainer");
        if (!ApplicationState.getInstance().hasLabType() && !this.instances.isEmpty()) {
            ListBox actionList = this.makeListBoxOfActions();
            FlowPanel subPageHeaderRight = new FlowPanel();
            subPageHeaderRight.setStyleName("pageHeaderRight");
            subPageHeaderRight.add((Widget)actionList);
            this.subPageHeaderPanel.add((Widget)subPageHeaderRight);
        }
        this.pageHeaderPanel.setStyleName("pageCategory");
        this.pageHeaderPanel.add((Widget)pageHeaderLabel);
        this.innerPanel.add((Widget)this.filterPanel);
        this.innerPanel.add((Widget)this.pageHeaderPanel);
        this.innerPanel.add((Widget)this.subPageHeaderPanel);
        this.innerPanel.add((Widget)this.resources);
        this.nonGridContentPanel.setStyleName("resourcesHeaderPanel");
        Label emptyHeader = new Label(this.getEmptyListMessage());
        this.nonGridContentPanel.add((Widget)emptyHeader);
        this.resources.add((Widget)this.nonGridContentPanel);
    }

    private String getName(WorkFlowTransition transition) {
        if (transition.getName().contains("Return to Draft")) {
            EIEntity fromEntity = (EIEntity)WorkFlowConstants.WORKFLOW_URI_MAP.get(transition.getFromStateURI());
            return transition.getName() + " from " + fromEntity.getLabel();
        }
        return transition.getName();
    }

    private boolean isUsefulTransition(WorkFlowTransition transition) {
        log.debug("checking if " + transition.getName() + " is useful");
        return !transition.getFromStateURI().equals((Object)transition.getToStateURI()) && !transition.getFromStateURI().equals((Object)WorkFlowConstants.NEW_URI);
    }

    private String getEmptyListMessage() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            return "No resources refer to " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        return "To see a list of resources, click the resource type, such as Instrument, or filter by Status or Laboratory above.";
    }

    private void drawFromApplicationState() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            return;
        }
        if (!QueryTokenObject.Mode.isResourcesList((QueryTokenObject.Mode)ApplicationState.getInstance().getMode())) {
            this.resources.clear();
            return;
        }
        if (!ApplicationState.getInstance().isPaginated()) {
            this.filterPanel.setCount(this.instances.size());
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            this.filterPanel.disable();
        }
        if (this.instances.size() == 0) {
            this.resources.remove((Widget)this.nonGridContentPanel);
            this.resources.clear();
            Label noInstances = new Label(this.getNoResourcesMessage());
            this.resources.add((Widget)noInstances);
            return;
        }
        this.resources.clear();
        this.subPageHeaderPanel.add((Widget)this.paginationWidget);
        this.setGridHeaders();
        this.updateGrid(0, this.instances);
    }

    private String getNoResourcesMessage() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            return "No resources refer to " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        return "No resources found";
    }

    private void setGridHeaders() {
        FlowPanel header = new FlowPanel();
        int i = 0;
        for (SortByProperties orderBy : SortByProperties.values()) {
            String columnName = orderBy.getColumnName();
            Anchor label = new Anchor(columnName);
            FlowPanel headerPanel = new FlowPanel();
            headerPanel.setStyleName(GRID_ROW_COLUMN_HEADER);
            headerPanel.addStyleName(GRID_ROW_COLUMN_HEADER + i++);
            if (orderBy.getParameterName() == ApplicationState.getInstance().getSortBy()) {
                headerPanel.addStyleName("gridRowColumnHeaderSelected");
            }
            headerPanel.add((Widget)label);
            header.add((Widget)headerPanel);
            label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        FlowPanel headerPanel456 = new FlowPanel();
        headerPanel456.setStyleName(GRID_ROW_COLUMN_HEADER);
        headerPanel456.addStyleName("gridRowColumnHeader456");
        FlowPanel headerPanel7 = new FlowPanel();
        headerPanel7.setStyleName(GRID_ROW_COLUMN_HEADER);
        headerPanel7.addStyleName("gridRowColumnHeader7");
        if (!ApplicationState.getInstance().hasLabType()) {
            CheckBox selectAllCheckBox = this.makeCheckBoxToSelectAll();
            headerPanel7.add((Widget)selectAllCheckBox);
        }
        header.add((Widget)headerPanel456);
        header.add((Widget)headerPanel7);
        this.resources.add((Widget)header);
        header.setStyleName("dtListGridHeader");
    }

    private CheckBox makeCheckBoxToSelectAll() {
        CheckBox checkBox = new CheckBox("");
        checkBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return checkBox;
    }

    private void removeRow(EIInstanceMinimal toRemove) {
        if (this.instanceRowMap.containsKey(toRemove)) {
            this.resources.remove((Widget)this.instanceRowMap.get(toRemove));
            this.instanceRowMap.remove(toRemove);
            this.instances.remove(toRemove);
        }
        this.filterPanel.setCount(this.instances.size());
    }

    private void sortGrid(List<EIInstanceMinimal> eiInstanceList, Comparator<EIInstanceMinimal> sorter) {
        Collections.sort(this.instances, sorter);
        for (EIInstanceMinimal instance : eiInstanceList) {
            this.resources.remove((Widget)this.instanceRowMap.get(instance));
            this.resources.add((Widget)this.instanceRowMap.get(instance));
        }
    }

    private void updateGrid(int initialRowNumber, List<EIInstanceMinimal> eiInstanceList) {
        for (EIInstanceMinimal instance : eiInstanceList) {
            GridRowWidget gridRowWidget = new GridRowWidget(instance, (RowDeletionListener)this);
            this.instanceRowMap.put(instance, gridRowWidget);
            this.resources.add((Widget)gridRowWidget);
        }
    }

    private Label getHeaderLabel() {
        String labelContent = "";
        if (ApplicationState.getInstance().hasType()) {
            labelContent = ApplicationState.getInstance().getTypeEntity().getLabel();
        } else if (ApplicationState.getInstance().getFilterTypeEntity() != EIEntity.NULL_ENTITY) {
            labelContent = ApplicationState.getInstance().getFilterTypeEntity().getLabel();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            labelContent = "Resources that reference " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.stubs) {
            labelContent = "Unfinished Tasks";
        } else if (!this.instances.isEmpty()) {
            labelContent = "All Resource Types";
        }
        Label headerLabel = new Label(labelContent);
        headerLabel.setStyleName("pageHeader");
        return headerLabel;
    }

    private void initializeSorters() {
        resourceSorters.put(RESOURCE_COLUMN_NAMES[0], new /* Unavailable Anonymous Inner Class!! */);
        resourceSorters.put(RESOURCE_COLUMN_NAMES[1], new /* Unavailable Anonymous Inner Class!! */);
        resourceSorters.put(RESOURCE_COLUMN_NAMES[2], new /* Unavailable Anonymous Inner Class!! */);
        resourceSorters.put(RESOURCE_COLUMN_NAMES[3], new /* Unavailable Anonymous Inner Class!! */);
    }

    private ListBox makeListBoxOfActions() {
        ListBox actionList = new ListBox();
        actionList.addItem("Actions");
        ArrayList actionNames = new ArrayList(this.actionTransitionMap.keySet());
        Collections.sort(actionNames);
        for (String actionName : actionNames) {
            actionList.addItem(actionName);
        }
        actionList.addItem("Claim");
        actionList.addItem("Share");
        actionList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionList;
    }

    private String getNames(List<EIInstanceMinimal> checkedInstances) {
        StringBuilder sb = new StringBuilder();
        for (EIInstanceMinimal checked : checkedInstances) {
            sb.append(checked.getInstanceLabel() + " ");
        }
        return sb.toString();
    }

    protected void makeConfirmationDialog(List<EIInstanceMinimal> instanceList, String name, String errorMessage, ClientRepositoryToolsManager.BulkWorkflowCallback callback, Performable performable) {
        String stubWarningMessage;
        log.debug("making confirmation dialog for " + name + " and " + instanceList.size() + " instances");
        VerticalPanel vpanel = this.makeVerticalPanelWithHeading(name + " the following resources:");
        ScrollPanel scrPanel = this.getScrollPanelWithDimensionsSet();
        FlexTable flexTable = this.getFlextableWithHeadingSet();
        ArrayList<EIInstanceMinimal> validInstances = new ArrayList<EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> stubInstances = new ArrayList<EIInstanceMinimal>();
        int instanceCount = 0;
        for (EIInstanceMinimal instance : instanceList) {
            if (!performable.isValidFor(instance)) continue;
            if (instance.isStub()) {
                log.debug("stub instance");
                stubInstances.add(instance);
                continue;
            }
            validInstances.add(instance);
            flexTable.setText(instanceCount + 2, 0, instance.getInstanceLabel());
            flexTable.setText(instanceCount + 2, 1, instance.getInstanceType().getLabel());
            flexTable.setText(instanceCount + 2, 2, instance.getWFState().getLabel());
            ++instanceCount;
        }
        String string = stubWarningMessage = stubInstances.size() > 0 ? this.makeErrorMessage("Please finish reviewing $RESOURCES$ before trying to $ACTION$.", "$RESOURCES$", stubInstances).replace("$ACTION$", name.toLowerCase()) : null;
        if (instanceCount == 0) {
            if (stubInstances.size() > 0) {
                Window.alert((String)stubWarningMessage);
            } else {
                Window.alert((String)errorMessage);
            }
            return;
        }
        if (validInstances.size() > 0) {
            EIConfirmationPopup popup = new EIConfirmationPopup("100%", "100%", stubWarningMessage);
            popup.addConfirmClickHandler(this.makeHandlerforBulkOperation(callback, performable, validInstances, (PopupPanel)popup));
            vpanel.add((Widget)scrPanel);
            scrPanel.add((Widget)flexTable);
            popup.add((Widget)vpanel);
            popup.show();
        }
    }

    private String makeErrorMessage(String bulkMessage, String toReplace, List<EIInstanceMinimal> stubInstances) {
        log.debug("making error message from: " + bulkMessage);
        StringBuilder instanceNames = new StringBuilder(stubInstances.get(0).getInstanceLabel());
        if (stubInstances.size() > 1) {
            for (EIInstanceMinimal minimal : stubInstances.subList(1, stubInstances.size())) {
                instanceNames.append(", " + minimal.getInstanceLabel());
            }
        }
        return bulkMessage.replace(toReplace, instanceNames);
    }

    protected boolean instanceMeetsFilterCriteria(EIInstanceMinimal eiInstance) {
        if (ApplicationState.getInstance().isStrictlyFilteredByOwner()) {
            return WorkflowUtils.isNotNull((EIEntity)eiInstance.getWFOwner());
        }
        return true;
    }

    protected List<EIInstanceMinimal> getCheckedInstances() {
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        for (EIInstanceMinimal eiInstance : this.instances) {
            GridRowWidget row = (GridRowWidget)this.instanceRowMap.get(eiInstance);
            if (row.getCheckBox() == null || !row.getCheckBox().isVisible() || !row.getCheckBox().getValue().booleanValue()) continue;
            instanceList.add(eiInstance);
        }
        return instanceList;
    }

    protected void bulkClaimOrRelease(ActionRedisplay redisplay, OwnershipAction claimOrReleaseAction, List<EIInstanceMinimal> checkedInstances, ClientRepositoryToolsManager.BulkWorkflowCallback bulkWorkflowCallback) {
        this.makeConfirmationDialog(checkedInstances, claimOrReleaseAction.getName(), "You cannot $ACTION$ any of the selected resources.".replace("$ACTION$", claimOrReleaseAction.getName().toLowerCase()), bulkWorkflowCallback, (Performable)claimOrReleaseAction);
    }

    protected ClientRepositoryToolsManager.BulkWorkflowCallback makeWorkflowCallback(EIInstanceMinimal[] instances, ActionRedisplay redisplay) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected ClientRepositoryToolsManager.BulkWorkflowCallback makeOwnershipCallback(EIInstanceMinimal[] instances, ActionRedisplay redisplay) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void bulkOperation(WorkFlowTransition transition, List<EIInstanceMinimal> selectedInstances, ClientRepositoryToolsManager.BulkWorkflowCallback callback) {
        this.makeConfirmationDialog(selectedInstances, transition.getName(), "You cannot $ACTION$ any of the selected resources.".replace("$ACTION$", transition.getName().toLowerCase()), callback, (Performable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private VerticalPanel makeVerticalPanelWithHeading(String headingString) {
        VerticalPanel vpanel = new VerticalPanel();
        Label heading = new Label(headingString);
        heading.setStyleName("dataPanelLabel");
        vpanel.add((Widget)heading);
        return vpanel;
    }

    private ClickHandler makeHandlerforBulkOperation(ClientRepositoryToolsManager.BulkWorkflowCallback callback, Performable performable, List<EIInstanceMinimal> instanceList, PopupPanel popup) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FlexTable getFlextableWithHeadingSet() {
        FlexTable flexTable = new FlexTable();
        flexTable.setStyleName("dataPanel");
        flexTable.setHTML(1, 0, "<b>Resource Name</b>");
        flexTable.setHTML(1, 1, "<b>Type</b>");
        flexTable.setHTML(1, 2, "<b>Status</b>");
        return flexTable;
    }

    private ScrollPanel getScrollPanelWithDimensionsSet() {
        ScrollPanel scrPanel = new ScrollPanel();
        scrPanel.setHeight("270px");
        scrPanel.setWidth("1000px");
        scrPanel.setHorizontalScrollPosition(-1);
        return scrPanel;
    }

    public void onRowDeletion(EIInstanceMinimal instance) {
        if (Lab.isLabType((EIEntity)instance.getInstanceType())) {
            ApplicationState.getInstance().updateLabCache();
        }
        this.removeRow(instance);
    }

    static /* synthetic */ GWTLogger access$000() {
        return log;
    }

    static /* synthetic */ List access$100(EIResourcesGrid x0) {
        return x0.instances;
    }

    static /* synthetic */ Map access$200() {
        return resourceSorters;
    }

    static /* synthetic */ void access$300(EIResourcesGrid x0, List x1, Comparator x2) {
        x0.sortGrid(x1, x2);
    }

    static /* synthetic */ Map access$400(EIResourcesGrid x0) {
        return x0.instanceRowMap;
    }

    static /* synthetic */ void access$500(EIResourcesGrid x0, EIInstanceMinimal x1) {
        x0.removeRow(x1);
    }

    static /* synthetic */ String access$600(EIResourcesGrid x0, List x1) {
        return x0.getNames(x1);
    }

    static /* synthetic */ Map access$700(EIResourcesGrid x0) {
        return x0.actionTransitionMap;
    }
}

