/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DatatoolsInstancePanel;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.EditFormRedisplay;
import org.eaglei.datatools.client.ui.EditFormsPanel;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.Lab;
import org.eaglei.datatools.client.ui.OntologyPropEditRenderer;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

public class EditFormsPanel
extends DatatoolsInstancePanel
implements NewInnerInstanceListener {
    private final List<EIInstance> newInnerInstances = new ArrayList();
    private String editToken;
    private final EditFormType formType;
    private final EditFormRedisplay formRedisplayCallbacks;
    private static final GWTLogger log = GWTLogger.getLogger((String)"EditFormsPanel");

    public static EditFormsPanel createEditForm(EIInstance instance, EIEntity labEntity, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, labEntity, displayCallbacks, EditFormType.Edit);
    }

    public static EditFormsPanel createNewForm(EIInstance instance, EIEntity labEntity, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, labEntity, displayCallbacks, EditFormType.New);
    }

    private EditFormsPanel(EIInstance instance, EIEntity labEntity, EditFormRedisplay displayCallbacks, EditFormType formType) {
        super(instance, (FormRedisplay)displayCallbacks);
        log.debug("creaing edit renderer for instance " + this.eiInstance);
        this.ontologyPropRenderer = new OntologyPropEditRenderer(this.eiInstance, this.ontologyPanel, (NewInnerInstanceListener)this);
        this.buttonPanel.setRootSuperClass(this.ontologyPropRenderer.getRootSuperClass());
        this.shouldShowReadOnlyProperties = true;
        this.formRedisplayCallbacks = displayCallbacks;
        this.formType = formType;
        this.setButtonState();
        if (!this.isNewForm()) {
            this.getEditToken();
        }
        if (Lab.isLabType((EIEntity)instance.getInstanceType())) {
            ApplicationState.getInstance().setLabEntity(instance.getEntity());
        }
        if (this.buttonPanel.getSaveButton().isEnabled()) {
            this.buttonPanel.getSaveButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.buttonPanel.getCancelButton().isEnabled()) {
            this.buttonPanel.getCancelButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.buttonPanel.setLabRestrictionSelector((ButtonsPanel.LabRestrictionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isNewForm() {
        return this.formType == EditFormType.New;
    }

    protected void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, VerticalPanel nonOntologyPanel) {
        if (!propertyEntity.getURI().toString().equals("http://eagle-i.org/ont/datatools/1.0/user_comments") && !propertyEntity.getURI().toString().equals("http://purl.obolibrary.org/obo/IAO_0000232")) {
            EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
            nonOntologyPanel.add((Widget)fields);
            for (String value : propertyValues) {
                fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value));
            }
        }
    }

    protected void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, VerticalPanel nonOntologyPanel) {
        EditWidgetCollection fields = new EditWidgetCollection(this.eiInstance, propertyEntity);
        nonOntologyPanel.add((Widget)fields);
        for (EIEntity value : propertyValues) {
            fields.addWidget((EditWidget)TextWidget.makeNonOntologyTextWidget((EIInstance)this.eiInstance, (EIEntity)propertyEntity, (String)value.getLabel()));
        }
    }

    protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
        return this.eiInstance.getNonOntologyLiteralProperties().keySet();
    }

    protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
        return this.eiInstance.getNonOntologyResourceProperties().keySet();
    }

    protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        Label commentOnComments = new Label("Comments and curator notes will not be published.");
        commentOnComments.setStyleName("commentOnComments");
        this.formPanel.add((Widget)commentOnComments);
        EIEntity comments = EIEntity.create((String)"http://eagle-i.org/ont/datatools/1.0/user_comments", (String)"Comments");
        EIEntity curatorComments = EIEntity.create((String)"http://purl.obolibrary.org/obo/IAO_0000232", (String)"Curator note");
        String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
        TextAreaWidget commentsArea = TextAreaWidget.makeNonOntologyTextArea((EIInstance)this.eiInstance, (EIEntity)comments, (String)"", (boolean)false, (String)commentValue);
        this.formPanel.add((Widget)commentsArea);
        String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
        TextAreaWidget curatorArea = TextAreaWidget.makeNonOntologyTextArea((EIInstance)this.eiInstance, (EIEntity)curatorComments, (String)"", (boolean)false, (String)curatorValue);
        this.formPanel.add((Widget)curatorArea);
    }

    protected void save() {
        if (!this.checkLabels()) {
            Window.alert((String)"Name is a required field for main resource and for linked and embedded resources.");
            return;
        }
        try {
            this.saveNewInnerInstances();
        }
        catch (Exception e) {
            log.error("could not (re-) get instance");
        }
    }

    private void saveMainInstance() throws Exception {
        if (this.isNewForm()) {
            this.saveNewForm();
        } else {
            if (this.eiInstance.getNonOntologyLiteralProperties().containsKey(DatatoolsUIConstants.isStubEntity)) {
                this.eiInstance.replaceNonOntologyLiteralPropertyAllValues(DatatoolsUIConstants.isStubEntity, new HashSet());
            }
            ClientRepositoryToolsManager.INSTANCE.updateInstance(this.eiInstance, this.editToken, (ClientRepositoryToolsManager.SaveResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void saveNewInnerInstances() throws Exception {
        if (this.newInnerInstances.size() == 0) {
            log.debug("no inner instances");
            this.saveMainInstance();
        } else {
            this.deduplicate();
            log.info("saving new inner instances");
            ClientRepositoryToolsManager.INSTANCE.createInstances(this.newInnerInstances, (ClientRepositoryToolsManager.EIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void deduplicate() {
        ArrayList<EIInstance> ignore = new ArrayList<EIInstance>();
        for (EIInstance instance : this.newInnerInstances) {
            if (ignore.contains(instance)) continue;
            for (EIInstance otherInstance : this.newInnerInstances) {
                if (ignore.contains(otherInstance) || !this.isDuplicate(instance, otherInstance)) continue;
                EIEntity property = this.eiInstance.findPropertyForInstance(otherInstance.getEntity());
                this.eiInstance.replaceObjectPropertyValue(property, otherInstance.getInstanceURI(), instance.getEntity());
                ignore.add(otherInstance);
            }
        }
        this.newInnerInstances.removeAll(ignore);
    }

    private boolean isDuplicate(EIInstance instance, EIInstance otherInstance) {
        if (instance == otherInstance || instance.getEntity().equals((Object)otherInstance.getEntity())) {
            return false;
        }
        return instance.getInstanceType().equals((Object)otherInstance.getInstanceType()) && instance.getInstanceLabel().equals(otherInstance.getInstanceLabel());
    }

    private boolean checkLabels() {
        if (this.isMissingLabel(this.eiInstance)) {
            return false;
        }
        for (EIInstance inner : this.newInnerInstances) {
            if (!this.isMissingLabel(inner)) continue;
            return false;
        }
        for (EIInstance inner : this.eiInstance.getEmbeddedInstanceList()) {
            if (!this.isMissingLabel(inner) || !inner.getObjectProperties().isEmpty() || !inner.getDatatypeProperties().isEmpty() || inner.getInstanceClass().equals((Object)inner.getRootSuperType())) continue;
            return false;
        }
        return true;
    }

    private boolean isMissingLabel(EIInstance instance) {
        return instance.getInstanceLabel() == null || instance.getInstanceLabel().trim().equals("");
    }

    private void saveNewForm() throws Exception {
        ClientRepositoryToolsManager.INSTANCE.createInstance(this.eiInstance, (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cancel() {
        try {
            if (this.formType == EditFormType.New) {
                if (Lab.isLabType((EIEntity)this.eiInstance.getInstanceType())) {
                    ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
                } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.duplicate) {
                    History.back();
                } else {
                    EIEntity typeEntity = this.eiInstance.getRootSuperType().getEntity();
                    ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.list, EIEntity.NULL_ENTITY, typeEntity, ApplicationState.getInstance().getLabEntity());
                }
            } else {
                ClientRepositoryToolsManager.INSTANCE.getInstance(this.eiInstance.getInstanceURI(), (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            log.error("could not get instance");
        }
    }

    protected void setButtonState() {
        this.buttonPanel.saveButton.setVisible(true);
        if (this.formType == EditFormType.New) {
            this.buttonPanel.copyResourceButton.setVisible(false);
            this.buttonPanel.cancelButton.setVisible(true);
        } else {
            this.buttonPanel.copyResourceButton.setVisible(true);
            this.buttonPanel.cancelButton.setVisible(true);
            this.buttonPanel.hideAllWorkflowButtons();
        }
        this.buttonPanel.editButton.setVisible(false);
        this.buttonPanel.claimReleaseButton.setVisible(false);
        this.buttonPanel.deleteButton.setVisible(false);
    }

    private void getEditToken() {
        try {
            ClientRepositoryToolsManager.INSTANCE.getToken(this.eiInstance, (ClientRepositoryToolsManager.TokenCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error("failed to get edit token for " + this.eiInstance + " with exception");
            Window.alert((String)"Currently unable to edit this resource. Logout and try again.");
        }
    }

    protected void drawReferencedBy() {
    }

    public void onInstanceAdded(EIInstance newInstance) {
        this.newInnerInstances.add(newInstance);
    }

    public void onInstanceRemoved(EIInstance newInstance) {
        this.newInnerInstances.remove(newInstance);
    }

    static /* synthetic */ void access$000(EditFormsPanel x0) {
        x0.cancel();
    }

    static /* synthetic */ EditFormRedisplay access$100(EditFormsPanel x0) {
        return x0.formRedisplayCallbacks;
    }

    static /* synthetic */ void access$200(EditFormsPanel x0) throws Exception {
        x0.saveMainInstance();
    }

    static /* synthetic */ GWTLogger access$300() {
        return log;
    }

    static /* synthetic */ String access$402(EditFormsPanel x0, String x1) {
        x0.editToken = x1;
        return x0.editToken;
    }
}

