/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.LoginLogoutPanel;

public class LoginLogoutPanel
extends Composite
implements ClientRepositoryToolsManager.SessionListener {
    private static LoginLogoutPanelUiBinder uiBinder = (LoginLogoutPanelUiBinder)GWT.create(LoginLogoutPanelUiBinder.class);
    private static GWTLogger log = GWTLogger.getLogger((String)"Datatools");
    @UiField
    protected Label welcomeLabel;
    @UiField
    protected Anchor logoutAnchor;
    @UiField
    protected UListElement loginList;
    @UiField
    protected TextBox userTextBox;
    @UiField
    protected PasswordTextBox passTextBox;
    @UiField
    protected Button loginButton;
    private boolean signedIn = false;

    public LoginLogoutPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.passTextBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.loginButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.signedIn) {
            this.logoutAnchor.setVisible(false);
        }
        this.logoutAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (DatatoolsCookies.getSession() != null) {
            this.onLogIn(DatatoolsCookies.getUserName(), DatatoolsCookies.getUserUri());
        }
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
    }

    private void performLogout() {
        ClientRepositoryToolsManager.INSTANCE.logOut();
    }

    public void onLogOut() {
        this.welcomeLabel.setText("Please login");
        this.loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.signedIn = false;
        this.userTextBox.setText("");
        this.passTextBox.setText("");
        this.logoutAnchor.setVisible(false);
    }

    public void onLogIn(String username, String userUri) {
        this.welcomeLabel.setText("Welcome, " + username);
        this.logoutAnchor.setVisible(true);
        this.loginList.removeFromParent();
        this.signedIn = true;
    }

    private void performLogin() {
        log.debug("triggered perfrom login");
        String user = this.userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert((String)"A user name is required.");
            return;
        }
        String pass = this.passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert((String)"A password is required.");
            return;
        }
        ClientRepositoryToolsManager.INSTANCE.logIn(user.trim(), pass.trim(), (ClientRepositoryToolsManager.UserCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(LoginLogoutPanel x0) {
        x0.performLogin();
    }

    static /* synthetic */ boolean access$100(LoginLogoutPanel x0) {
        return x0.signedIn;
    }

    static /* synthetic */ void access$200(LoginLogoutPanel x0) {
        x0.performLogout();
    }
}

