/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.EIResourcesGrid;
import org.eaglei.datatools.client.ui.FormsPanelFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

public class MainController
implements ApplicationStateChangeListener {
    public static final String DATATOOLS_FILTER = "DatatoolsFilter";
    public static final String DATATOOLS_CONTROLS = "DatatoolsControls";
    private static final GWTLogger log = GWTLogger.getLogger((String)"MainController");

    public MainController() {
        ApplicationState.getInstance().addApplicationStateListener((ApplicationStateChangeListener)this);
        this.onApplicationStateChange();
    }

    public void onApplicationStateChange() {
        if (!ApplicationState.getInstance().hasUser()) {
            log.info("no user!");
            Datatools.clearDataPanel();
            return;
        }
        if (QueryTokenObject.Mode.isResourcesList((QueryTokenObject.Mode)ApplicationState.getInstance().getMode())) {
            this.drawResourcesListMode();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.workbench) {
            this.drawWorkbench();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.view) {
            this.drawView();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.edit) {
            this.drawEdit();
        }
    }

    private void drawResourcesListMode() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            if (ApplicationState.getInstance().hasInstance()) {
                log.info("showing references to " + ApplicationState.getInstance().getInstanceEntity().getLabel());
                this.drawGrid();
            } else {
                log.warn("trying to display references mode with no instance!");
                Window.alert((String)"Trying to display references without a referrent!");
            }
        } else {
            this.drawGrid();
        }
    }

    protected void drawWorkbench() {
        Datatools.showWorkbench();
    }

    protected void drawGrid() {
        EIURI labUri;
        EIURI WFStateUri;
        EIURI typeUri;
        Datatools.clearDataPanel();
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            Datatools.showData((Widget)new EIResourcesGrid());
            return;
        }
        if (this.applicationShouldShowEmptyGrid()) {
            Datatools.showData((Widget)new EIResourcesGrid());
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter) {
            typeUri = ApplicationState.getInstance().getFilterTypeUri();
            WFStateUri = ApplicationState.getInstance().getFilterWorkflowUri();
            labUri = ApplicationState.getInstance().getFilterLabUri();
            log.debug("setting parameters for filter query: " + typeUri + ", " + WFStateUri + ", " + labUri);
        } else {
            typeUri = ApplicationState.getInstance().getTypeUri();
            WFStateUri = EIURI.NULL_EIURI;
            labUri = ApplicationState.getInstance().getLabUri();
            log.debug("setting parameters for unfiltered query: " + typeUri + ", " + WFStateUri + ", " + labUri);
        }
        Datatools.showGlasspane();
        try {
            AuthSearchRequest request = new AuthSearchRequest();
            if (ApplicationState.getInstance().isPaginated()) {
                request.setPaginated(true);
                request.setStartIndex(ApplicationState.getInstance().getOffset().intValue());
                request.setMaxResults(ApplicationState.getInstance().getLimit().intValue());
            } else {
                request.setPaginated(false);
            }
            if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
                ClientRepositoryToolsManager.INSTANCE.listReferencingResources(ApplicationState.getInstance().getInstanceUri(), request, SortByProperties.getOrderBy((String)ApplicationState.getInstance().getSortBy()), ApplicationState.getInstance().isStrictlyFilteredByOwner(), this.getDisplayCallback());
            } else {
                boolean requestStubs;
                request.setType(typeUri);
                request.setWFState(WFStateUri);
                request.setLab(labUri);
                boolean bl = requestStubs = ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.stubs;
                if (requestStubs) {
                    log.debug("requesting stubs; type is " + typeUri + "; instance is " + ApplicationState.getInstance().getInstanceUri());
                }
                ClientRepositoryToolsManager.INSTANCE.listResources(request, SortByProperties.getOrderBy((String)ApplicationState.getInstance().getSortBy()), ApplicationState.getInstance().isStrictlyFilteredByOwner(), requestStubs, this.getDisplayCallback());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private boolean applicationShouldShowEmptyGrid() {
        return false;
    }

    private ClientRepositoryToolsManager.MinimalEIInstancesCallback getDisplayCallback() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void drawView() {
        log.debug("viewing " + ApplicationState.getInstance().getInstanceEntity());
        Datatools.clearDataPanel();
        Datatools.showData((Widget)FormsPanelFactory.generateViewForm((EIURI)ApplicationState.getInstance().getInstanceUri()));
    }

    protected void drawEdit() {
        log.debug("editing " + ApplicationState.getInstance().getInstanceEntity());
        Datatools.clearDataPanel();
        if (!ApplicationState.getInstance().hasInstance()) {
            Datatools.showData((Widget)FormsPanelFactory.generateNewForm((EIEntity)ApplicationState.getInstance().getTypeEntity()));
        } else {
            Datatools.showData((Widget)FormsPanelFactory.generateEditForm((EIURI)ApplicationState.getInstance().getInstanceUri()));
        }
    }

    public void onLogIn(String username, String userUri) {
        log.debug("main controller logged in, calling on AppStateChange; mode = " + ApplicationState.getInstance().getMode() + "; type = " + ApplicationState.getInstance().getTypeEntity());
        this.onApplicationStateChange();
    }

    public void onLogOut() {
        this.onApplicationStateChange();
    }
}

