/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.ui.VerticalPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public abstract class OntologyPropertiesRenderer {
    private static final GWTLogger log = GWTLogger.getLogger((String)"OntologyPropEditRenderer");
    protected EIInstance eiInstance;
    protected EIClass eiClass;
    protected List<EIProperty> eiProperties;
    protected Map<EIEntity, EIProperty> eiPropertiesEntityMap = new HashMap();
    protected VerticalPanel ontologyPanel;
    protected EIClass rootSuperClass;

    public abstract Collection<EIEntity> getDataTypeEntities();

    public abstract Collection<EIEntity> getObjectTypeEntities();

    public abstract void addFormTitle(String var1);

    public OntologyPropertiesRenderer(EIInstance eiInstance, VerticalPanel ontologyPanel) {
        this.ontologyPanel = ontologyPanel;
        this.eiInstance = eiInstance;
        this.eiClass = eiInstance.getInstanceClass();
        this.initializeProperties();
    }

    public void renderOntologyProperties() {
        String labelPrefix = InstanceWidgetUtils.isLabProperty((EIClass)this.eiInstance.getInstanceClass()) ? "Laboratory" : (this.rootSuperClass != null ? this.rootSuperClass.getEntity().getLabel() : this.eiClass.getEntity().getLabel());
        this.addFormTitle(labelPrefix);
        this.addNameProperty(labelPrefix);
        this.addTypeProperty(labelPrefix);
        Collection dataProps = this.getDataTypeEntities();
        Collection objectProps = this.getObjectTypeEntities();
        Map instanceDataTypeProperties = this.eiInstance.getDatatypeProperties();
        Map instanceObjectProperties = this.eiInstance.getObjectProperties();
        List reorderedProperties = this.reorderProperties(labelPrefix, instanceDataTypeProperties);
        for (EIProperty property : reorderedProperties) {
            if (property instanceof EIDatatypeProperty && dataProps.contains(property.getEntity())) {
                this.drawDataProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (!(property instanceof EIObjectProperty) || !objectProps.contains(property.getEntity())) continue;
            this.drawObjectProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceObjectProperties.get(property.getEntity()));
        }
    }

    private List<EIProperty> reorderProperties(String labelPrefix, Map<EIEntity, Set<String>> instanceDataTypeProperties) {
        ArrayList<EIProperty> personProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> contactProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> labProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> dateProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> primaryProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> secondaryProperties = new ArrayList<EIProperty>();
        Collection dataprops = this.getDataTypeEntities();
        for (EIProperty property : this.eiProperties) {
            if (property.getEntity().equals((Object)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY) && dataprops.contains(property.getEntity())) {
                EIEntity newDescriptionEntity = EIEntity.create((EIURI)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY.getLabel()));
                this.drawDataProperty(newDescriptionEntity, property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (property.getEntity().equals((Object)EagleIEntityConstants.SYNONYM_ENTITY) && dataprops.contains(property.getEntity())) {
                EIEntity newSynonymEntity = EIEntity.create((EIURI)EagleIEntityConstants.SYNONYM_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.SYNONYM_ENTITY.getLabel()));
                this.drawDataProperty(newSynonymEntity, property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (this.hasPersonRange(property)) {
                personProperties.add(property);
                continue;
            }
            if (property.getEntity().getLabel().contains("date")) {
                dateProperties.add(property);
                continue;
            }
            Set annotations = property.getAnnotations();
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab")) {
                labProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_ContactLocation") || annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_EmailContact")) {
                contactProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_PrimaryProperties")) {
                primaryProperties.add(property);
                continue;
            }
            secondaryProperties.add(property);
        }
        ArrayList<EIProperty> reorderedProperties = new ArrayList<EIProperty>();
        reorderedProperties.addAll(labProperties);
        reorderedProperties.addAll(personProperties);
        reorderedProperties.addAll(contactProperties);
        Collections.reverse(dateProperties);
        reorderedProperties.addAll(dateProperties);
        reorderedProperties.addAll(primaryProperties);
        reorderedProperties.addAll(secondaryProperties);
        return reorderedProperties;
    }

    private boolean hasPersonRange(EIProperty property) {
        if (!(property instanceof EIObjectProperty)) {
            return false;
        }
        List ranges = ((EIObjectProperty)property).getRangeList();
        return ranges.size() == 1 && ((EIClass)ranges.get(0)).getEntity().getURI().equals((Object)EagleIEntityConstants.FOAF_PERSON_URI);
    }

    protected void addNameProperty(String labelPrefix) {
        EIEntity namePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel()));
        this.drawDataProperty(namePropEntity, "", true, (Set)this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
    }

    protected void addTypeProperty(String labelPrefix) {
        EIEntity typePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel()));
        this.drawObjectProperty(typePropEntity, "", true, (Set)this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
    }

    protected HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    protected HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    protected HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected abstract void drawDataProperty(EIEntity var1, String var2, boolean var3, Set<String> var4);

    protected abstract void drawObjectProperty(EIEntity var1, String var2, boolean var3, Set<EIEntity> var4);

    protected void initializeProperties() {
        ClientModelManager.INSTANCE.getProperties(this.eiClass, (ClientModelManager.PropertyCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setRootSuperClass() {
        try {
            ClientModelManager.INSTANCE.getRootSuperClass(this.eiClass, (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (LoggedException loggedException) {
            // empty catch block
        }
    }

    private void fetchConstants() {
        if (ApplicationState.getInstance().getEmbeddedClasses() == null) {
            ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class", (ClientModelManager.ClassesInGroupCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.finishSetup();
        }
    }

    protected void finishSetup() {
        this.renderOntologyProperties();
    }

    protected EIClass getRootSuperClass() {
        return this.rootSuperClass;
    }

    static /* synthetic */ GWTLogger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(OntologyPropertiesRenderer x0) {
        x0.fetchConstants();
    }
}

