/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.Window;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.Performable;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;

public class OwnershipAction
implements Performable {
    public static final OwnershipAction ClaimAction = new OwnershipAction("claim");
    public static final OwnershipAction ReleaseAction = new OwnershipAction("share");
    final String name;

    private OwnershipAction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OwnershipAction toggle() {
        if (this.name.equals(OwnershipAction.ClaimAction.name)) {
            return ReleaseAction;
        }
        return ClaimAction;
    }

    public void perform(EIInstance instance, ActionRedisplay redisplay) {
        this.perform(EIInstanceMinimal.create((EIInstance)instance), redisplay);
    }

    public void perform(EIInstanceMinimal instance, ActionRedisplay redisplay) {
        EIInstanceMinimal[] singleton = new EIInstanceMinimal[]{instance};
        this.perform(singleton, redisplay);
    }

    public void perform(EIInstanceMinimal[] instances, ActionRedisplay redisplay) {
        this.perform(instances, this.makeCallback(instances, redisplay));
    }

    public void perform(EIInstanceMinimal[] instances, ClientRepositoryToolsManager.BulkWorkflowCallback callback) {
        try {
            if (this.name.equals(OwnershipAction.ClaimAction.name)) {
                ClientRepositoryToolsManager.INSTANCE.claim(instances, callback);
            } else {
                ClientRepositoryToolsManager.INSTANCE.release(instances, callback);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Window.alert((String)e.getMessage());
        }
    }

    private ClientRepositoryToolsManager.BulkWorkflowCallback makeCallback(EIInstanceMinimal[] instances, ActionRedisplay redisplay) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean isValidFor(EIInstanceMinimal instance) {
        if (this.name.equals(OwnershipAction.ClaimAction.name)) {
            return ClientRepositoryToolsManager.INSTANCE.canClaim(instance);
        }
        return ClientRepositoryToolsManager.INSTANCE.canEdit(instance);
    }
}

