/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.model.EIEntity;

public class BreadcrumbWidget
extends HorizontalPanel
implements ApplicationStateChangeListener {
    private final Anchor homeLink;
    private final Anchor workbenchLink;
    private Anchor labLink;
    private Anchor resourcesLink;
    private EIEntity labEntity = EIEntity.NULL_ENTITY;
    private static final String nextCrumb = "  >  ";
    private static final GWTLogger log = GWTLogger.getLogger((String)"BreadcrumbWidget");

    public BreadcrumbWidget() {
        this.homeLink = new Anchor("Home");
        this.add((Widget)this.homeLink);
        this.homeLink.setEnabled(false);
        this.homeLink.setStyleName("disabledLink");
        this.addNextCrumb();
        this.workbenchLink = new Anchor("Workbench");
        this.workbenchLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this.workbenchLink);
        this.showPrevious(this.workbenchLink);
        this.addNextCrumb();
        this.labLink = new Anchor("");
        this.labLink.setVisible(false);
        this.labLink.setEnabled(false);
        this.labLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this.labLink);
        this.addNextCrumb();
        this.resourcesLink = new Anchor("Resources");
        this.resourcesLink.setVisible(false);
        this.resourcesLink.setEnabled(false);
        this.add((Widget)this.resourcesLink);
    }

    public void onApplicationStateChange() {
        log.debug("breadcrumb widget app state changed");
        this.labEntity = ApplicationState.getInstance().getLabEntity();
        if (ApplicationState.getInstance().hasLab()) {
            log.debug("has lab");
            this.labLink.setText(ApplicationState.getInstance().getLabEntity().getLabel());
            this.labLink.setVisible(true);
            this.labLink.setEnabled(true);
            this.showPrevious(this.labLink);
            this.hideFollowing(this.labLink);
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.workbench) {
            log.debug("workbench mode");
            this.workbenchLink.setVisible(true);
            this.showPrevious(this.workbenchLink);
            this.hideFollowing(this.workbenchLink);
        } else {
            log.debug("no lab");
            this.labLink.setText("");
            this.labLink.setVisible(false);
            this.labLink.setEnabled(false);
            this.hideFollowing(this.labLink);
        }
        if (this.labEntity != EIEntity.NULL_ENTITY && QueryTokenObject.Mode.isResourcesList((QueryTokenObject.Mode)ApplicationState.getInstance().getMode())) {
            String label = ApplicationState.getInstance().getTypeEntity().equals((Object)EIEntity.NULL_ENTITY) ? "Resources" : ApplicationState.getInstance().getTypeEntity().getLabel();
            this.resourcesLink.setText(label);
            this.resourcesLink.setVisible(true);
            this.resourcesLink.setEnabled(true);
            this.showPrevious(this.resourcesLink);
        }
    }

    public void reset() {
        this.hideFollowing(this.workbenchLink);
        this.labLink.setText("");
        this.labLink.setVisible(false);
        this.labLink.setEnabled(false);
        this.hideFollowing(this.labLink);
        this.resourcesLink.setText("");
        this.resourcesLink.setVisible(false);
        this.resourcesLink.setEnabled(false);
    }

    private void addNextCrumb() {
        Label nextWidgetLabel = new Label(nextCrumb);
        nextWidgetLabel.setStyleName("breadCrumbArrow");
        this.add((Widget)nextWidgetLabel);
        nextWidgetLabel.setVisible(false);
    }

    private void showPrevious(Anchor anchor) {
        if (this.getWidgetIndex((Widget)anchor) > 0) {
            this.getWidget(this.getWidgetIndex((Widget)anchor) - 1).setVisible(true);
        }
    }

    private void hideFollowing(Anchor clickedAnchor) {
        int clickedWidgetIndex = this.getWidgetIndex((Widget)clickedAnchor);
        for (int i = clickedWidgetIndex + 1; i < this.getWidgetCount(); ++i) {
            this.getWidget(i).setVisible(false);
        }
    }

    static /* synthetic */ Anchor access$000(BreadcrumbWidget x0) {
        return x0.workbenchLink;
    }

    static /* synthetic */ void access$100(BreadcrumbWidget x0, Anchor x1) {
        x0.hideFollowing(x1);
    }

    static /* synthetic */ EIEntity access$202(BreadcrumbWidget x0, EIEntity x1) {
        x0.labEntity = x1;
        return x0.labEntity;
    }

    static /* synthetic */ Anchor access$300(BreadcrumbWidget x0) {
        return x0.labLink;
    }

    static /* synthetic */ EIEntity access$200(BreadcrumbWidget x0) {
        return x0.labEntity;
    }

    static /* synthetic */ GWTLogger access$400() {
        return log;
    }
}

