/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.StubWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

public class EIResourceListWidget
extends EditWidget {
    private static final String CREATE_NEW_VALUE = "<create new>";
    private static final String NO_VALUE = "<none>";
    private final ListBox instances = new ListBox();
    private final EIClass range;
    private final boolean shouldHaveLabel;
    private final boolean isPropertyLabRelated;
    private final NewInnerInstanceListener listener;
    private final FlowPanel valuePanel;
    private StubWidget stubWidget;
    private Anchor allLabsAnchor;
    private Label stubMessage;
    private static String FROM_ALL_LABS_LABEL = "See choices from all labs.  ";
    private static String FROM_ONLY_CURRENT_LAB = "Restrict to choices from this lab.  ";
    private final Anchor changeLabLink;
    private static final String CHANGE_LABS = "Change lab.";
    private static GWTLogger log = GWTLogger.getLogger((String)"EIResourceListWidget");

    public EIResourceListWidget(EIInstance instance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, boolean shouldShowLabel, boolean isPropertyLabRelated, NewInnerInstanceListener listener) {
        super(instance, propertyEntity, propertyDefinition, isRequired, Layout.Horizontal);
        this.range = range;
        this.listener = listener;
        if (selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY) {
            this.oldValue = selectedEntity.getURI().toString();
            if (selectedEntity.getLabel().equals("") || selectedEntity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) {
                selectedEntity.setLabel(selectedEntity.getURI().toString());
            }
        }
        this.shouldHaveLabel = shouldShowLabel;
        if (!this.shouldHaveLabel) {
            this.widgetPanel.remove((Widget)this.label);
        }
        this.isPropertyLabRelated = isPropertyLabRelated;
        this.valuePanel = new FlowPanel();
        this.valuePanel.setStyleName("ResourceListPanel");
        this.widgetPanel.add((Widget)this.valuePanel);
        this.changeLabLink = new Anchor(CHANGE_LABS);
        this.stubMessage = new Label("Can be completed after saving.");
        this.stubMessage.setStyleName("commentOnComments");
        this.setup();
        this.intializeInstances();
    }

    private void intializeInstances() {
        this.instances.setStyleName("formDropdown");
        this.addDefaultInstanceValues();
        if (this.range.equals((Object)EIClass.NULL_CLASS)) {
            log.info("skipping get instances");
            if (this.hasOldValue()) {
                this.instances.removeItem(this.instances.getItemCount() - 1);
                String probablyDeletedLabel = "[non-standard link] " + this.getOldStringValue();
                this.instances.addItem(probablyDeletedLabel, this.getOldStringValue());
                this.instances.setSelectedIndex(this.instances.getItemCount() - 1);
            }
        } else if (!this.isInLab()) {
            this.fillListBoxWithResources(false, EIURI.NULL_EIURI);
        } else {
            this.fillListBoxWithResources(true, ApplicationState.getInstance().getLabUri());
        }
        this.instances.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fillListBoxWithResources(boolean onlyFromThisLab, EIURI labEIURI) {
        try {
            this.instances.clear();
            this.instances.addItem("...loading...", null);
            log.debug("requesting resource list for " + this.range.getEntity().getURI());
            ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue(this.range.getEntity().getURI(), labEIURI, EIURI.NULL_EIURI, !this.isPropertyLabRelated && onlyFromThisLab, (ClientRepositoryToolsManager.MinimalEIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void setInstancesAndPickLists(boolean onlyFromThisLab, List<EIInstanceMinimal> result) {
        this.instances.clear();
        this.instances.addItem(NO_VALUE, null);
        this.instances.addItem(CREATE_NEW_VALUE, null);
        if (!onlyFromThisLab && ApplicationState.getInstance().hasLab()) {
            int j = result.size() - 1;
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(j).getLab().equals((Object)ApplicationState.getInstance().getLabEntity())) {
                    result.add(0, result.remove(j));
                    continue;
                }
                --j;
            }
        }
        for (EIInstanceMinimal instance : result) {
            this.instances.addItem(this.formatInstanceForListBox(instance), instance.getInstanceURI().toString());
            if (ApplicationState.getInstance().hasLab() && instance.getLab().equals((Object)ApplicationState.getInstance().getLabEntity())) {
                Element childElement = (Element)this.instances.getElement().getChild(this.instances.getItemCount() - 1);
                childElement.setClassName("ownlabTxt");
            }
            if (!instance.getInstanceURI().toString().equals(this.oldValue)) continue;
            this.instances.setSelectedIndex(this.instances.getItemCount() - 1);
        }
    }

    private boolean oldValueMissingFromResult(List<EIInstanceMinimal> fetchedInstances) {
        EIURI oldUri = EIURI.create((String)this.oldValue);
        for (EIInstanceMinimal instance : fetchedInstances) {
            if (!instance.getInstanceURI().equals((Object)oldUri)) continue;
            return false;
        }
        return true;
    }

    private void addDefaultInstanceValues() {
        this.instances.addItem(NO_VALUE, null);
        this.instances.addItem(CREATE_NEW_VALUE, null);
        this.instances.addItem("...loading...", null);
    }

    private void doOnChange(EIInstance instance, EIClass range, EIEntity propertyEntity, String propertyValue, ListBox subClassList) {
        if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(NO_VALUE)) {
            this.removeValue();
            if (this.stubWidget != null) {
                this.valuePanel.remove((Widget)this.stubMessage);
                this.listener.onInstanceRemoved(this.stubWidget.getEIInstance());
            }
            this.allLabsAnchor.setVisible(true);
        } else if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(CREATE_NEW_VALUE)) {
            ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(range.getEntity().getURI(), (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.allLabsAnchor.setVisible(true);
            if (this.stubWidget != null) {
                this.listener.onInstanceRemoved(this.stubWidget.getEIInstance());
                this.valuePanel.remove((Widget)this.stubWidget);
            }
            if (this.allLabsAnchor.getText().equals(FROM_ONLY_CURRENT_LAB)) {
                this.allLabsAnchor.setVisible(false);
            }
            if (this.hasOldValue()) {
                this.eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create((String)this.oldValue), WidgetUtils.getSelectedEntity((ListBox)subClassList));
            } else {
                this.eiInstance.addObjectProperty(propertyEntity, WidgetUtils.getSelectedEntity((ListBox)subClassList));
            }
            this.updateOldValue(WidgetUtils.getSelectedUri((ListBox)subClassList));
        }
    }

    private void setup() {
        this.instances.setName(this.propertyEntity.getURI().toString() + "_instances");
        this.valuePanel.add((Widget)this.instances);
        this.allLabsAnchor = new Anchor(FROM_ALL_LABS_LABEL);
        this.allLabsAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.isInLab()) {
            this.valuePanel.add((Widget)this.allLabsAnchor);
        }
    }

    private boolean isInLab() {
        return ApplicationState.getInstance().hasLab();
    }

    private void fillResourceListAndToggle() {
        if (this.allLabsAnchor.getText().equals(FROM_ALL_LABS_LABEL)) {
            this.fillListBoxWithResources(false, EIURI.NULL_EIURI);
            this.allLabsAnchor.setText(FROM_ONLY_CURRENT_LAB);
        } else {
            this.fillListBoxWithResources(true, ApplicationState.getInstance().getLabUri());
            this.allLabsAnchor.setText(FROM_ALL_LABS_LABEL);
        }
    }

    private String formatInstanceForListBox(EIInstanceMinimal valueInstance) {
        return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">" + (!valueInstance.getLab().equals((Object)EIEntity.NULL_ENTITY) ? ", " + valueInstance.getLab().getLabel() : "");
    }

    public EditWidget duplicateBlank() {
        return new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.range, (EIEntity)null, true, this.isPropertyLabRelated, this.listener);
    }

    protected void removeValue() {
        if (this.hasOldValue()) {
            if (this.stubWidget != null) {
                this.valuePanel.remove((Widget)this.stubWidget);
            }
            this.eiInstance.replaceObjectPropertyValue(this.propertyEntity, this.getOldEIURIValue(), null);
            this.oldValue = null;
        }
    }

    public void disableAsLabProperty() {
        this.instances.setEnabled(false);
        this.allLabsAnchor.setVisible(false);
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.duplicate) {
            this.valuePanel.remove((Widget)this.allLabsAnchor);
            this.valuePanel.add((Widget)this.changeLabLink);
            this.changeLabLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ EIClass access$000(EIResourceListWidget x0) {
        return x0.range;
    }

    static /* synthetic */ ListBox access$100(EIResourceListWidget x0) {
        return x0.instances;
    }

    static /* synthetic */ void access$200(EIResourceListWidget x0, EIInstance x1, EIClass x2, EIEntity x3, String x4, ListBox x5) {
        x0.doOnChange(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ boolean access$300(EIResourceListWidget x0, List x1) {
        return x0.oldValueMissingFromResult(x1);
    }

    static /* synthetic */ void access$400(EIResourceListWidget x0, boolean x1, List x2) {
        x0.setInstancesAndPickLists(x1, x2);
    }

    static /* synthetic */ String access$500() {
        return FROM_ONLY_CURRENT_LAB;
    }

    static /* synthetic */ Anchor access$600(EIResourceListWidget x0) {
        return x0.allLabsAnchor;
    }

    static /* synthetic */ GWTLogger access$700() {
        return log;
    }

    static /* synthetic */ NewInnerInstanceListener access$800(EIResourceListWidget x0) {
        return x0.listener;
    }

    static /* synthetic */ StubWidget access$902(EIResourceListWidget x0, StubWidget x1) {
        x0.stubWidget = x1;
        return x0.stubWidget;
    }

    static /* synthetic */ Label access$1000(EIResourceListWidget x0) {
        return x0.stubMessage;
    }

    static /* synthetic */ FlowPanel access$1100(EIResourceListWidget x0) {
        return x0.valuePanel;
    }

    static /* synthetic */ StubWidget access$900(EIResourceListWidget x0) {
        return x0.stubWidget;
    }

    static /* synthetic */ void access$1200(EIResourceListWidget x0) {
        x0.fillResourceListAndToggle();
    }

    static /* synthetic */ Anchor access$1300(EIResourceListWidget x0) {
        return x0.changeLabLink;
    }
}

