/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public abstract class EditWidget
extends Composite {
    protected ComplexPanel widgetPanel;
    protected EIInstance eiInstance;
    protected EIEntity propertyEntity;
    protected String propertyDefinition;
    protected boolean isRequired;
    protected String oldValue;
    protected boolean shouldShowLabel;
    protected Label label;
    protected final String name;
    private static GWTLogger log = GWTLogger.getLogger((String)"EditWidget");

    EditWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Layout layout) {
        this.widgetPanel = layout.getLayoutedPanel();
        log.debug(this.widgetPanel.toString());
        this.name = propertyEntity.getURI().toString();
        this.eiInstance = eiInstance;
        this.propertyEntity = propertyEntity;
        this.propertyDefinition = propertyDefinition;
        this.isRequired = isRequired;
        this.label = InstanceWidgetUtils.createLabel((EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired);
        this.widgetPanel.add((Widget)this.label);
        this.initWidget((Widget)this.widgetPanel);
    }

    protected void setLabelContents(String newContents) {
        this.label.setText(newContents);
    }

    protected void updateOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    protected void updateOldValue(EIURI oldValue) {
        this.oldValue = oldValue.toString();
    }

    protected abstract void removeValue();

    public abstract EditWidget duplicateBlank();

    protected EIURI getOldEIURIValue() {
        return EIURI.create((String)this.oldValue);
    }

    protected String getOldStringValue() {
        return this.oldValue;
    }

    protected boolean hasOldValue() {
        return this.oldValue != null && !this.oldValue.equals(EIEntity.NULL_ENTITY.getURI().toString()) && !"".equals(this.oldValue);
    }

    public boolean shouldShowLabel() {
        return this.shouldShowLabel;
    }

    protected String getLabel() {
        return this.propertyEntity.getLabel();
    }

    public void setShouldShowLabel(boolean shouldShowLabel) {
        this.shouldShowLabel = shouldShowLabel;
        if (!shouldShowLabel) {
            this.setLabelContents("");
        } else {
            this.setLabelContents(this.getLabel());
        }
    }

    public String getName() {
        return this.name;
    }
}

