/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EIResourceListWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class ObjectWidget
extends EditWidget {
    private final ListBox rangePicker = new ListBox();
    private List<EIClass> rangeList = new ArrayList();
    private final EIEntity selectedEntity;
    private EIClass instanceRootClass;
    private List<EIClass> instanceSuperclasses;
    private EditWidget innerWidget;
    private final EIEntity labEntity;
    private boolean isEnabled = true;
    private final NewInnerInstanceListener listener;
    private final boolean isPropertyLabRelated;
    private final Map<EIEntity, EIClass> entityRangeMap = new HashMap();
    private static final String NO_VALUE = "<none>";
    private static final GWTLogger log = GWTLogger.getLogger((String)"ObjectWidget");

    public ObjectWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, List<EIClass> rangeList, EIEntity labEntity, EIEntity selectedEntity, boolean isPropertyLabRelated, NewInnerInstanceListener listener) {
        super(eiInstance, propertyEntity, propertyDefinition, isRequired, Layout.Horizontal);
        log.debug("range list has " + rangeList.size() + " entries");
        this.rangeList = rangeList;
        Collections.sort(this.rangeList, new /* Unavailable Anonymous Inner Class!! */);
        this.listener = listener;
        this.selectedEntity = selectedEntity;
        this.isPropertyLabRelated = isPropertyLabRelated;
        log.debug("selected entity is: " + this.selectedEntity);
        this.labEntity = labEntity;
        this.getInstanceRootClass();
    }

    private void setup() {
        this.rangePicker.setStyleName("MultiRangeDropbox");
        this.widgetPanel.add((Widget)this.rangePicker);
        this.rangePicker.addItem(NO_VALUE, NO_VALUE);
        for (EIClass range : this.rangeList) {
            this.entityRangeMap.put(range.getEntity(), range);
            this.rangePicker.addItem(range.getEntity().getLabel(), range.getEntity().getURI().toString());
            if (this.instanceRootClass == null && this.instanceSuperclasses != null && this.instanceSuperclasses.contains(range)) {
                this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
                continue;
            }
            if (this.instanceRootClass != null && range.getEntity().equals((Object)this.instanceRootClass.getEntity())) {
                this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
                continue;
            }
            if (!this.hasLabUri() || !InstanceWidgetUtils.isLabProperty((EIClass)range)) continue;
            this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
        }
        this.selectProperValue();
        this.setRangePickBehavior();
    }

    private void setRangePickBehavior() {
        this.rangePicker.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void selectProperValue() {
        if (this.rangePicker.getSelectedIndex() > 0) {
            EIEntity selectedRange = this.getSelectedRangeEntity();
            if (((EIClass)this.entityRangeMap.get(selectedRange)).isEagleIResource()) {
                if (this.selectedEntity == null && this.hasLabUri() && this.isPropertyLabRelated) {
                    log.info("making lab-property for " + this.entityRangeMap.get(selectedRange) + " " + this.labEntity);
                    this.eiInstance.addObjectProperty(this.propertyEntity, this.labEntity);
                    this.innerWidget = new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, (EIClass)this.entityRangeMap.get(selectedRange), this.labEntity, false, this.isPropertyLabRelated, this.listener);
                    this.disable();
                } else {
                    this.innerWidget = new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, (EIClass)this.entityRangeMap.get(selectedRange), this.selectedEntity, false, this.isPropertyLabRelated, this.listener);
                    if (this.hasLabUri() && this.isPropertyLabRelated) {
                        this.disable();
                    }
                }
                this.widgetPanel.add((Widget)this.innerWidget);
            } else {
                HorizontalPanel tempPanel = new HorizontalPanel();
                this.widgetPanel.add((Widget)tempPanel);
                WidgetUtils.addTermWidgetToPanel((EIInstance)this.eiInstance, (EIEntity)this.propertyEntity, (String)this.propertyDefinition, (boolean)this.isRequired, (EIClass)this.instanceRootClass, (EIEntity)this.selectedEntity, (HorizontalPanel)tempPanel, (boolean)false);
            }
        } else if (this.selectedEntity != null && this.selectedEntity != EIEntity.NULL_ENTITY) {
            log.info("trying to make widget for deleted value");
            this.innerWidget = new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, EIClass.NULL_CLASS, this.selectedEntity, false, this.isPropertyLabRelated, this.listener);
            this.widgetPanel.add((Widget)this.innerWidget);
        }
    }

    private void getInstanceRootClass() {
        if (this.selectedEntity == null) {
            log.info("no selected entity");
            this.setup();
            return;
        }
        if (WidgetUtils.isInstance((EIEntity)this.selectedEntity)) {
            log.debug("Trying to get superclasses for instance: " + this.selectedEntity);
            ClientRepositoryToolsManager.INSTANCE.getClassAndSuperclassesForInstanceUri(this.selectedEntity.getURI(), (ClientRepositoryToolsManager.EIClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            log.debug("in getInstanceRootClass for " + this.selectedEntity);
            ClientModelManager.INSTANCE.getClass(this.selectedEntity.getURI(), (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private EIEntity getSelectedRangeEntity() {
        return WidgetUtils.getSelectedEntity((ListBox)this.rangePicker);
    }

    protected EditWidget getInnerWidget() {
        if (this.innerWidget != null) {
            return this.innerWidget;
        }
        if (this.widgetPanel.getWidgetCount() > 2) {
            Widget widget = this.widgetPanel.getWidget(2);
            if (widget instanceof HorizontalPanel && (widget = ((HorizontalPanel)widget).getWidget(0)) != null) {
                return (EditWidget)widget;
            }
            if (widget instanceof EditWidget) {
                EditWidget inner = (EditWidget)widget;
                return inner;
            }
            Window.alert((String)"Failed to get an editWidget");
        }
        return null;
    }

    protected boolean hasOldValue() {
        if (this.getInnerWidget() == null) {
            return false;
        }
        return this.getInnerWidget().hasOldValue();
    }

    protected void removeValue() {
        if (this.getInnerWidget() == null) {
            return;
        }
        this.getInnerWidget().removeValue();
    }

    public EditWidget duplicateBlank() {
        return new ObjectWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.rangeList, this.labEntity, null, this.isPropertyLabRelated, this.listener);
    }

    protected boolean hasLabUri() {
        return this.labEntity != null && !this.labEntity.getURI().toString().equals("");
    }

    public void disable() {
        this.rangePicker.setEnabled(false);
        if (this.innerWidget instanceof EIResourceListWidget) {
            ((EIResourceListWidget)this.innerWidget).disableAsLabProperty();
        }
        this.isEnabled = false;
    }

    public boolean isDisabled() {
        return !this.isEnabled;
    }

    static /* synthetic */ ListBox access$000(ObjectWidget x0) {
        return x0.rangePicker;
    }

    static /* synthetic */ EditWidget access$102(ObjectWidget x0, EditWidget x1) {
        x0.innerWidget = x1;
        return x0.innerWidget;
    }

    static /* synthetic */ EIEntity access$200(ObjectWidget x0) {
        return x0.getSelectedRangeEntity();
    }

    static /* synthetic */ Map access$300(ObjectWidget x0) {
        return x0.entityRangeMap;
    }

    static /* synthetic */ boolean access$400(ObjectWidget x0) {
        return x0.isPropertyLabRelated;
    }

    static /* synthetic */ NewInnerInstanceListener access$500(ObjectWidget x0) {
        return x0.listener;
    }

    static /* synthetic */ EditWidget access$100(ObjectWidget x0) {
        return x0.innerWidget;
    }

    static /* synthetic */ GWTLogger access$600() {
        return log;
    }

    static /* synthetic */ List access$702(ObjectWidget x0, List x1) {
        x0.instanceSuperclasses = x1;
        return x0.instanceSuperclasses;
    }

    static /* synthetic */ List access$700(ObjectWidget x0) {
        return x0.instanceSuperclasses;
    }

    static /* synthetic */ void access$800(ObjectWidget x0) {
        x0.setup();
    }

    static /* synthetic */ EIClass access$902(ObjectWidget x0, EIClass x1) {
        x0.instanceRootClass = x1;
        return x0.instanceRootClass;
    }
}

