/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RepositoryToolsModelServlet
extends RemoteServiceServlet
implements RepositoryToolsModelService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryToolsModelServlet.class);
    private RepositoryProvider provider = null;
    private EIOntModel ontModel;
    private DatatoolsConfiguration config;
    private static String DATAMODELCREATE_ANNOTATION_URI = "http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate";

    public void init() throws ServletException {
        this.config = this.getConfiguration();
        try {
            this.initializeOntology();
        }
        catch (Exception e) {
            log.error((Object)("Error initializing RepositoryToolsModelServlet: " + e));
            throw new ServletException((Throwable)e);
        }
        log.info((Object)"init succesful");
    }

    protected void initializeOntology() throws Exception {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.doDependencyInjection((ApplicationContext)ctx);
    }

    protected void doDependencyInjection(ApplicationContext springAppContext) throws Exception {
        this.ontModel = (EIOntModel)springAppContext.getBean(EIOntModel.class);
        this.provider = new RESTRepositoryProvider(this.config, (JenaEIInstanceFactory)springAppContext.getBean(JenaEIInstanceFactory.class));
    }

    public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws Exception {
        try {
            if (this.isNull(instance)) {
                log.error((Object)"trying to create a null instance");
            }
            this.handleNullSession(session);
            this.provider.createInstance(session, instance, workspaceEntity);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                log.error((Object)element.toString());
            }
            throw new LoggedException(e.getMessage());
        }
    }

    public void createInstances(Session session, List<EIInstance> instances, EIEntity workspaceEntity) throws Exception {
        try {
            if (instances == null) {
                log.error((Object)"trying to create null instances");
            }
            this.handleNullSession(session);
            this.provider.createInstances(session, instances, workspaceEntity);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                log.error((Object)element.toString());
            }
            throw new LoggedException(e.getMessage());
        }
    }

    public void deleteInstance(Session session, EIURI instanceUri) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.deleteInstance(session, instanceUri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void deleteInstances(Session session, List<EIURI> instanceUris) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.deleteInstances(session, instanceUris);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String getToken(Session session, EIInstance instance) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getToken(session, instance);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public Map<EIInstance, String> getTokens(Session session, List<EIInstance> instances) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getTokens(session, instances);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void updateInstance(Session session, EIInstance instance, String token) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.updateInstance(session, instance, token);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public void updateInstances(Session session, Map<EIInstance, String> instancesWithTokens) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.updateInstances(session, instancesWithTokens);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public User login(String user, String password) throws Exception {
        try {
            return this.provider.login(user, password);
        }
        catch (Exception e) {
            throw new LoggedException("Repository error:" + e.getLocalizedMessage());
        }
    }

    public void logout(Session session) throws Exception {
        try {
            this.handleNullSession(session);
            this.provider.logout(session);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public User whoami(Session session) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.whoami(session);
        }
        catch (Exception e) {
            log.error((Object)("whoami exception " + e));
            throw new LoggedException(e.getMessage());
        }
    }

    private DatatoolsConfiguration getConfiguration() throws ServletException {
        String propFile = System.getProperty("datatools.config.file");
        if (propFile == null) {
            propFile = "datatools.prop";
        }
        log.debug((Object)("Using properties file " + propFile));
        URL configURL = this.getClass().getClassLoader().getResource(propFile);
        if (configURL == null) {
            log.error((Object)("Could not locate " + propFile + " on classpath "));
            throw new ServletException("Could not locate " + propFile + " on classpath ");
        }
        try {
            File configFile = new File(configURL.toURI());
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            log.error((Object)("Error loading configuration from " + configURL + " " + e));
            throw new ServletException("Error loading configuration from " + configURL + " " + e);
        }
    }

    public boolean isOnline() {
        return this.provider.isOnline();
    }

    public List<EIInstanceMinimal> EIQuery(Session session, String query) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.EIQuery(session, query);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getEmptyEIInstance(session, classUri, instanceEntity);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws Exception {
        try {
            this.handleNullSession(session);
            EIInstance instance = this.provider.getEmptyEIInstance(session, classUri);
            if (instance.getInstanceClass() == null || instance.getInstanceClass().equals((Object)EIClass.NULL_CLASS)) {
                instance.setInstanceClass(this.ontModel.getClass(classUri));
            }
            return instance;
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance deepCopy(Session session, EIURI originalUri) throws Exception {
        this.handleNullSession(session);
        return this.provider.deepCopy(session, originalUri);
    }

    public List<EIURI> getNewInstanceID(Session session, int count) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.getNewInstanceID(session, count);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String query(Session session, String sparql) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.query(session, sparql);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIInstance getInstance(Session session, EIURI instanceID) throws Exception {
        this.handleNullSession(session);
        return this.provider.getInstance(session, instanceID);
    }

    public List<EIInstanceMinimal> listResourcesForObjectPropertyValue(Session session, EIURI classUri, EIURI lab, EIURI state, boolean onlyLab) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.listResourcesForObjectPropertyValue(session, classUri, lab, state, onlyLab);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public String retrieveLabel(Session session, EIURI uri) throws Exception {
        try {
            this.handleNullSession(session);
            return this.provider.retrieveLabel(session, uri);
        }
        catch (Exception e) {
            throw new LoggedException(e.getMessage());
        }
    }

    public EIClass getRootSuperclassForInstanceUri(Session session, EIURI instanceUri) throws Exception {
        this.handleNullSession(session);
        EIInstance instance = this.provider.getInstance(session, instanceUri);
        if (this.isNull(instance)) {
            return null;
        }
        return this.getRootSuperClass(instance.getInstanceClass());
    }

    private boolean isNull(EIInstance instance) {
        return instance == null || instance.getInstanceURI() == null || EIInstance.NULL_INSTANCE.equals(instance);
    }

    public List<EIClass> getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri) throws Exception {
        this.handleNullSession(session);
        EIInstance instance = this.provider.getInstance(session, instanceUri);
        if (this.isNull(instance)) {
            return null;
        }
        ArrayList<EIClass> classes = this.ontModel.getSuperClasses(instance.getInstanceType().getURI());
        if (classes == null || classes.isEmpty()) {
            classes = new ArrayList<EIClass>(1);
        }
        classes.add(this.ontModel.getClass(instance.getInstanceType().getURI()));
        return classes;
    }

    public EIClass getRootSuperClass(EIClass eclass) throws LoggedException {
        EIClass found = eclass;
        while (found.hasSuperClass()) {
            found = this.ontModel.getSuperClass(found);
        }
        return found;
    }

    public EIClass getSuperClass(EIClass eclass) throws LoggedException {
        return this.ontModel.getSuperClass(eclass);
    }

    public boolean isModelClassURI(String uri) {
        return this.ontModel.isModelClassURI(uri);
    }

    public List<Workspace> getWorkspaces(Session session) throws Exception {
        this.handleNullSession(session);
        return this.provider.getWorkspaces(session);
    }

    public List<EIProperty> getAllEquivalentClasses(List<EIProperty> propertiesToPopulate) {
        for (EIProperty property : propertiesToPopulate) {
            if (!(property instanceof EIObjectProperty)) continue;
            EIObjectProperty objectProperty = (EIObjectProperty)property;
            log.debug((Object)("equivalent classes for object property " + property));
            List assertedRanges = objectProperty.getRangeList();
            log.debug((Object)("   had " + (assertedRanges == null ? "0" : Integer.valueOf(assertedRanges.size())) + " asserted ranges"));
            for (EIClass range : assertedRanges) {
                if (range == null || range.equals((Object)EIClass.NULL_CLASS) || range.getEntity() == null || range.getEntity().equals((Object)EIEntity.NULL_ENTITY)) continue;
                List equivalentClasses = this.ontModel.getEquivalentClasses(range.getEntity().getURI());
                if (equivalentClasses != null) {
                    range.setEquivalentClasses(equivalentClasses);
                    for (EIEquivalentClass equivalence : equivalentClasses) {
                        log.debug((Object)("    equivalent class " + (equivalence.getEquivalentTo() == null ? "empty" : Integer.valueOf(equivalence.getEquivalentTo().size()))));
                    }
                    continue;
                }
                log.debug((Object)"null classes");
            }
        }
        return propertiesToPopulate;
    }

    public List<EIClass> getTopClassesAnotatedByDataModelCreate() {
        try {
            List listOfDataModelCreateAnnotation = this.ontModel.getClassesInGroup(DATAMODELCREATE_ANNOTATION_URI);
            log.info((Object)("the size of the eiclasses returned for Data model create sub class is  " + listOfDataModelCreateAnnotation.size()));
            return listOfDataModelCreateAnnotation;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    private boolean isValid(Session session) {
        return session != null && session.getSessionId() != null;
    }

    private void handleNullSession(Session session) throws Exception {
        if (!this.isValid(session)) {
            throw new LoggedException("No session information was found.");
        }
    }

    public List<EIURI> claim(Session session, List<EIURI> uris) throws Exception {
        return this.provider.claim(session, uris);
    }

    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws Exception {
        return this.provider.listResources(session, queryRequest, orderBy, strictOwnerFilter);
    }

    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, boolean stubsOnly) throws Exception {
        return this.provider.listResources(session, queryRequest, orderBy, strictOwnerFilter, stubsOnly);
    }

    public List<EIInstanceMinimal> listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws Exception {
        return this.provider.listReferencingResources(session, resourceUri, queryRequest, orderBy, strictOwnerFilter);
    }

    public List<WorkFlowTransition> listWorkFlowTransitions(Session session, EIEntity workspaceEntity) throws Exception {
        return this.provider.listWorkFlowTransitions(session, workspaceEntity);
    }

    public List<EIURI> release(Session session, List<EIURI> uris) throws Exception {
        return this.provider.release(session, uris);
    }

    public List<EIURI> transition(Session session, List<EIURI> uris, EIEntity transitionEntity) throws Exception {
        return this.provider.transition(session, uris, transitionEntity);
    }

    public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws Exception {
        return this.provider.getModifiedDates(session, uris);
    }

    public boolean addLabToUser(Session session, EIURI labUri) throws Exception {
        return false;
    }

    public boolean isModelClassURI(EIURI uri) {
        return this.ontModel.isModelClassURI(uri.toString());
    }
}

