package org.eaglei.institution.server;

import java.io.IOException;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.config.SearchProperties;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.AggregatingSearchProvider;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchResultRankMerger;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.search.provider.rdf.RepositoryHarvester;
import org.eaglei.search.provider.rdf.SPARQLProtocolProvider;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

/**
 * Allows programatic specification of bean implementations, while leveraging
 * spring to provide DI and ensure singleton scope.
 */
@Configuration
@ImportResource("classpath:search-common-config.xml")
public class InstitutionSearchConfig {
    
    @Autowired
    private EIOntModel eagleiOntModel;

    @Autowired
    private RepositoryHarvester harvester;
    
    @Autowired
    private InstitutionRegistry registry;    
    
    @Bean
    public SearchProvider rootSearchProvider() {
        try {

            final boolean test = isTest();
            
            // TODO constructors probably shouldn't be throwing checked exceptions

            SearchProvider nestedProvider;
            if (test) {
                final EIEntity institution = registry.getInstitution();
                final DataGenParams params = DataGenParams.createForOneInstitution(institution.getURI().toString(), institution.getLabel());            
                params.setMaterializeHierarchy(true);        
                nestedProvider = new RDFModelProvider(eagleiOntModel, params, institution);
            } else {
                nestedProvider = harvester;
            }
            return new CompositeLuceneProvider(eagleiOntModel, nestedProvider);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Checks if the test property is enabled.
     */
    private static boolean isTest() {
        boolean test = false;
        final String testMode = System.getProperty(SearchProperties.SEARCH_TEST);
        if (testMode != null && Boolean.parseBoolean(testMode)) {
            test = true;
        }
        return test;
    }

}
