package org.eaglei.lexical;

import org.eaglei.model.EIEntity;

/**
 * Interface for classes that represent on potential entity match for a segment
 * of text.
 * 
 * @author rfrost
 */
public interface EntityMatch {

    /**
     * Gets match entity.
     * 
     * @return Match entity.
     */
    public EIEntity getEntity();

    /**
     * Gets a match score.
     * 
     * @return Match score as a float.
     */
    public float getScore();

    /**
     * Gets the match highlight.
     *  
     * @return Match highlight. HTML syntax.
     */
    public String getHighlight();
    
    /**
     * Gets label of the entity on which the match was made. This may be different than
     * the preferred label of the entity.
     *  
     * @return Match label. No HTML syntax.
     */
    public String getMatchLabel();
    
    /**
     * Gets label of the "root type" of this entity. 
     * Will be null if the entity is itself a root type.
     *  
     * @return Root type label. No HTML syntax.
     */
    public String getRootTypeLabel();

}
