package org.eaglei.lexical;

import java.io.IOException;
import java.util.List;

/**
 * Interface for classes that support entity extraction from text. 
 * 
 * The exact extraction behavior is determined by the implementation (i.e. may be customized for
 * an auto-suggest feature and use an EdgeNGram anlyzer or may be customized for use with
 * entity extraction on full text and use a PorterStemAnalyzer).
 * 
 * @author rfrost
 */
public interface EntityExtractionProvider {
    
    /**
     * Attempts to extract entities from the specified request.
     * 
     * @param request The match request.
     * 
     * @return List of matches in relevance rank order. 
     * 
     * @exception IOException Thrown if an error is encountered.
     */
    public List<EntityMatch> match(EntityMatchRequest request) throws IOException;
}
