package org.eaglei.lexical.lucene;

import org.eaglei.lexical.EntityMatch;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

/**
 * Implementation of EntityMatch
 * 
 * @author rfrost
 */
public final class EntityMatchImpl implements EntityMatch {

    private String highlight;
    private String matchLabel;
    private EIEntity entity;
    private String rootTypeLabel;
    private float score;

    /**
     * Creates a new EntityMatchImpl.
     * @param prefLabel Preferred label of the entity. 
     * @param matchLabel Matched label of the entity.
     * @param highlight Highlighted match. 
     * @param URI URI of the entity.
     * @param score Score of the match.
     */
    public EntityMatchImpl(final String prefLabel, final String matchLabel, final String highlight, final String URI, final float score) {
        assert prefLabel != null;
        assert highlight != null;
        assert matchLabel != null;        
        assert URI != null;
        assert score >= 0;
        this.entity = EIEntity.create(EIURI.create(URI), prefLabel);
        this.highlight = highlight;
        this.matchLabel = matchLabel;
        this.score = score;
    }

    @Override
    public EIEntity getEntity() {
        return this.entity;
    }

    @Override
    public float getScore() {
        return this.score;
    }
    
    @Override
    public String getHighlight() {
        return this.highlight;
    }
    
    @Override
    public String getMatchLabel() {
        return this.matchLabel;
    }
    
    public void setRootTypeLabel(String rootTypeLabel) {
    	this.rootTypeLabel = rootTypeLabel;
    }
    
    @Override
    public String getRootTypeLabel() {
    	return this.rootTypeLabel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.highlight);
        sb.append(" (");
        sb.append(this.entity);
        sb.append(", ");
        sb.append(this.score);
        sb.append(")");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        return this.entity.hashCode();
    }
    
    @Override
    public boolean equals(Object other) {
        if (! (other instanceof EntityMatchImpl)) {
            return false;
        }
        return ((EntityMatchImpl) other).entity.equals(entity);
    }
}
