/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIResource;
import org.eaglei.model.EIURI;

public class EIInstance
extends EIResource
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static final EIEntity WFStateEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowState"), "Workflow state");
    private static final EIEntity WFOwnerEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner"), "Workflow owner");
    private static final EIEntity CreatedEntity = EIEntity.create(EIURI.create("http://purl.org/dc/terms/created"), "Creation date");
    EIEntity instanceType;
    List<EIEntity> otherEITypes;
    Map<EIEntity, Set<EIURI>> objectProperties = new HashMap<EIEntity, Set<EIURI>>();
    Map<EIEntity, Set<String>> datatypeProperties = new HashMap<EIEntity, Set<String>>();
    Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIURI>>();
    Map<EIEntity, Set<String>> nonOntologyLiteralProperties = new HashMap<EIEntity, Set<String>>();
    Map<EIEntity, EIURI> readOnlyResourceProperties;
    Map<EIEntity, String> readOnlyLiteralProperties;

    private EIInstance() {
    }

    private EIInstance(EIEntity instanceType, EIEntity instanceEntity) {
        super(instanceEntity);
        this.instanceType = instanceType;
    }

    public static EIInstance create(EIEntity instanceType, EIEntity instanceEntity) {
        return new EIInstance(instanceType, instanceEntity);
    }

    public void addObjectPropertyToInstance(EIEntity property, EIURI resource) {
        Set<EIURI> pValues;
        if (this.objectProperties != null) {
            pValues = this.objectProperties.get(property);
            if (pValues == null) {
                pValues = new HashSet<EIURI>();
                this.objectProperties.put(property, pValues);
            }
        } else {
            this.objectProperties = new HashMap<EIEntity, Set<EIURI>>();
            pValues = new HashSet<EIURI>();
            this.objectProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public void addDatattypePropertyToInstance(EIEntity property, String literal) {
        Set<String> pValues;
        if (this.datatypeProperties != null) {
            pValues = this.datatypeProperties.get(property);
            if (pValues == null) {
                pValues = new HashSet<String>();
                this.datatypeProperties.put(property, pValues);
            }
        } else {
            this.datatypeProperties = new HashMap<EIEntity, Set<String>>();
            pValues = new HashSet<String>();
            this.datatypeProperties.put(property, pValues);
        }
        pValues.add(literal);
    }

    public void replaceNonOntologyResourceProperty(EIEntity property, EIURI resource) {
        Set<EIURI> pValues;
        if (this.nonOntologyResourceProperties != null) {
            pValues = this.nonOntologyResourceProperties.get(property);
            if (pValues == null) {
                pValues = new HashSet<EIURI>();
                this.nonOntologyResourceProperties.put(property, pValues);
            } else {
                pValues.clear();
            }
        } else {
            this.nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIURI>>();
            pValues = new HashSet<EIURI>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public void addNonOntologyResourceProperty(EIEntity property, EIURI resource) {
        Set<EIURI> pValues;
        if (this.nonOntologyResourceProperties != null) {
            pValues = this.nonOntologyResourceProperties.get(property);
            if (pValues == null) {
                pValues = new HashSet<EIURI>();
                this.nonOntologyResourceProperties.put(property, pValues);
            }
        } else {
            this.nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIURI>>();
            pValues = new HashSet<EIURI>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public void addNonOntologyLiteralProperty(EIEntity property, String literal) {
        Set<String> pValues;
        if (this.nonOntologyLiteralProperties != null) {
            pValues = this.nonOntologyLiteralProperties.get(property);
            if (pValues == null) {
                pValues = new HashSet<String>();
                this.nonOntologyLiteralProperties.put(property, pValues);
            }
        } else {
            this.nonOntologyLiteralProperties = new HashMap<EIEntity, Set<String>>();
            pValues = new HashSet<String>();
            this.nonOntologyLiteralProperties.put(property, pValues);
        }
        pValues.add(literal);
    }

    public void addEIType(EIEntity eiType) {
        if (eiType == null) {
            return;
        }
        if (this.otherEITypes == null) {
            this.otherEITypes = new ArrayList<EIEntity>();
        }
        this.otherEITypes.add(eiType);
    }

    public void setObjectProperties(Map<EIEntity, Set<EIURI>> objectProperties) {
        this.objectProperties = objectProperties;
    }

    public void setDatatypeProperties(Map<EIEntity, Set<String>> datatypeProperties) {
        this.datatypeProperties = datatypeProperties;
    }

    public void setOtherEITypes(List<EIEntity> eiTypes) {
        this.otherEITypes = eiTypes;
    }

    public Map<EIEntity, Set<EIURI>> getObjectProperties() {
        if (this.objectProperties == null) {
            return Collections.emptyMap();
        }
        return this.objectProperties;
    }

    public Map<EIEntity, Set<String>> getDatatypeProperties() {
        if (this.datatypeProperties == null) {
            return Collections.emptyMap();
        }
        return this.datatypeProperties;
    }

    public List<EIEntity> getOtherEITypes() {
        if (this.otherEITypes == null) {
            return Collections.emptyList();
        }
        return this.otherEITypes;
    }

    public EIURI getInstanceURI() {
        return this.getEntity().getURI();
    }

    public String getInstanceLabel() {
        return this.getEntity().getLabel();
    }

    public EIEntity getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(EIEntity instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public String toString() {
        return this.instanceType.toString() + " : " + this.getEntity().toString();
    }

    public Map<EIEntity, Set<EIURI>> getNonOntologyResourceProperties() {
        if (this.nonOntologyResourceProperties == null) {
            return Collections.emptyMap();
        }
        return this.nonOntologyResourceProperties;
    }

    public void setNonOntologyResourceProperties(Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties) {
        this.nonOntologyResourceProperties = nonOntologyResourceProperties;
    }

    public Map<EIEntity, Set<String>> getNonOntologyLiteralProperties() {
        if (this.nonOntologyLiteralProperties == null) {
            return Collections.emptyMap();
        }
        return this.nonOntologyLiteralProperties;
    }

    public void setNonOntologyLiteralProperties(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        this.nonOntologyLiteralProperties = nonOntologyLiteralProperties;
    }

    public EIURI getWFState() {
        if (this.readOnlyResourceProperties == null) {
            return null;
        }
        if (this.readOnlyResourceProperties.containsKey(WFStateEntity)) {
            EIURI state = this.readOnlyResourceProperties.get(WFStateEntity);
            return state;
        }
        return null;
    }

    public void setWFState(EIURI state) {
        this.setReadOnlyResourceProperty(WFStateEntity, state);
    }

    public EIURI getWFOwner() {
        if (this.readOnlyResourceProperties == null) {
            return null;
        }
        if (this.readOnlyResourceProperties.containsKey(WFOwnerEntity)) {
            EIURI state = this.readOnlyResourceProperties.get(WFOwnerEntity);
            return state;
        }
        return null;
    }

    public void setWFOwner(EIURI ownerUri) {
        this.setReadOnlyResourceProperty(WFOwnerEntity, ownerUri);
    }

    public String getCreationDate() {
        if (this.readOnlyLiteralProperties == null) {
            return null;
        }
        if (this.readOnlyLiteralProperties.containsKey(CreatedEntity)) {
            String created = this.readOnlyLiteralProperties.get(CreatedEntity);
            return created;
        }
        return null;
    }

    public void setCreationDate(String date) {
        this.setReadOnlyLiteralProperty(CreatedEntity, date);
    }

    public int compareTo(Object o) {
        if (!(o instanceof EIInstance)) {
            return 0;
        }
        return this.getEntity().getLabel().compareToIgnoreCase(((EIInstance)o).getEntity().getLabel());
    }

    public Map<EIEntity, EIURI> getReadOnlyResourceProperties() {
        if (this.readOnlyResourceProperties == null) {
            return Collections.emptyMap();
        }
        return this.readOnlyResourceProperties;
    }

    public void setReadOnlyResourceProperties(Map<EIEntity, EIURI> readOnlyResourceProperties) {
        this.readOnlyResourceProperties = readOnlyResourceProperties;
    }

    public void setReadOnlyResourceProperty(EIEntity property, EIURI value) {
        if (this.readOnlyResourceProperties == null) {
            this.readOnlyResourceProperties = new HashMap<EIEntity, EIURI>();
        }
        this.readOnlyResourceProperties.put(property, value);
    }

    public Map<EIEntity, String> getReadOnlyLiteralProperties() {
        if (this.readOnlyLiteralProperties == null) {
            return Collections.emptyMap();
        }
        return this.readOnlyLiteralProperties;
    }

    public void setReadOnlyLiteralProperties(Map<EIEntity, String> readOnlyLiteralProperties) {
        this.readOnlyLiteralProperties = readOnlyLiteralProperties;
    }

    public void setReadOnlyLiteralProperty(EIEntity property, String value) {
        if (this.readOnlyLiteralProperties == null) {
            this.readOnlyLiteralProperties = new HashMap<EIEntity, String>();
        }
        this.readOnlyLiteralProperties.put(property, value);
    }
}

