package org.eaglei.model;

import java.io.Serializable;
import java.util.List;

public class EIClass extends EIOntResource implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private boolean hasProperty;
    private boolean hasSubClass;
    private boolean hasSuperClass;
    private boolean isEagleIResource;

    private transient EIClass superclass = null;
    private transient List<EIClass> subclasses = null;
    private transient List<EIProperty> properties = null;

    private EIClass() {
        // for GWT
    }

    public EIClass(EIEntity entity, boolean hasProperty, boolean hasSubClass, boolean hasSuperClass, boolean isEagleIResource) {
        super(entity);
        this.hasProperty = hasProperty;
        this.hasSubClass = hasSubClass;
        this.hasSuperClass = hasSuperClass;
        this.isEagleIResource = isEagleIResource;
    }

    /**
     * Returns true if this class is an eagle-i class 
     * (a top-level resource class or a subclass of a top-level class).
     * Returns false if this class is not an eagle-i resource
     * class.
     *  
     * @return
     */
    public boolean isEagleIResource() {
        return isEagleIResource;
    }
    
    public boolean hasProperty() {
        return hasProperty;
    }

    public boolean hasSubClass() {
        return hasSubClass;
    }

    /**
     * Indicates whether this class has a superclass.
     * The "top-level" resource classes are defined as having a
     * no superclass.
     * 
     * @return
     */
    public boolean hasSuperClass() {
        return hasSuperClass;
    }

    /**
     * Gets the superclass of this class. This value is lazily populated
     * and will be null until setSuperClass() has been called.  If this
     * is a "top-level" resource class, it will always have a null superclass.
     * Calling this method does not set the value.
     * 
     * @return null if hasSuperClass() is false or if the superclass has not been
     *         set yet.
     */
    public EIClass getSuperClass() {
        return superclass;
    }

    public void setSuperClass(EIClass superclass) {
        this.superclass = superclass;
    }

    /**
     * Gets the subclasses of this class. The subclass list is lazily populated
     * and will be null until setSubClasses() has been called. This method does
     * not populate the list.
     * 
     * @return null if hasSubClass is false or if the subclass list has not been
     *         set yet.
     */
    public List<EIClass> getSubClasses() {
        return subclasses;
    }

    public void setSubClasses(List<EIClass> subclasses) {
        this.subclasses = subclasses;
    }

    /**
     * Gets the properties of this class. The properties list is lazily
     * populated and will be null until setProperties() has been called. This
     * method does not populate the list.
     * 
     * @return null if hasProperties is false or if the properties list has not
     *         been set yet.
     */
    public List<EIProperty> getProperties() {
        return properties;
    }

    public void setProperties(List<EIProperty> properties) {
        this.properties = properties;
    }

}
