package org.eaglei.model;

import java.util.Collections;
import java.util.List;

public class EIObjectProperty extends EIProperty {

    private static final long serialVersionUID = 1L;
    
    private List<EIClass> rangeClasses;

    private EIObjectProperty() {
        // for gwt
    }

    public EIObjectProperty(EIEntity entity, EIClass rangeClass) {
        this(entity, Collections.singletonList(rangeClass));
    }

    public EIObjectProperty(EIEntity entity, List<EIClass> rangeClasses) {
        super(entity);
        setRange(rangeClasses);
    }

    /**
     * If there are more than one range class, returns the first one.
     * 
     * @return
     * @deprecated Should call getRangeList() instead.
     */
    public EIClass getRange() {
        return rangeClasses.get(0);
    }

    /**
     * If there are more than one range class, returns the first one.
     * 
     * @return
     */
    public List<EIClass> getRangeList() {
        return rangeClasses;
    }

    /**
     * This method is only here to support cache unmarshalling of this class.
     * This field is logically immutable.
     * 
     * @param rangeClass
     */
    public void setRange(EIClass rangeClass) {
        setRange(Collections.singletonList(rangeClass));
    }


    /**
     * This method is only here to support cache unmarshalling of this class.
     * This field is logically immutable.
     * 
     * @param rangeClasses
     */
    public void setRange(List<EIClass> rangeClasses) {
        this.rangeClasses = rangeClasses;
    }
}
