package org.eaglei.model;

import java.io.Serializable;

public abstract class EIResource implements Serializable {

    private EIEntity entity;

    protected EIResource() {
        // for GWT
    }

    protected EIResource(EIEntity entity) {
        assert entity != null;
        this.entity = entity;
    }
    
    public EIEntity getEntity() {
        return entity;
    }

    public void setLabel(String label){
    	this.entity.setLabel(label);
    }
    
    @Override
    public int hashCode() {
        return getEntity().hashCode();
    }

    @Override
    public String toString() {
        return entity.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EIResource))
            return false;
        EIResource other = (EIResource) o;
        if (!other.getEntity().equals(getEntity()))
            return false;
        return true;
    }
    
}
