package org.eaglei.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EIClass extends EIOntResource implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private boolean isInferred;
    private boolean hasProperty;
    private boolean hasSubClass;
    private boolean hasSuperClass;
    private boolean hasEquivalentClass;
    private boolean isEagleIResource;

    private transient EIClass superclass = null;
    private transient List<EIClass> superclasses = null;
    private transient List<EIClass> subclasses = null;
    private transient List<EIProperty> properties = null;
    private transient List<EIEquivalentClass> equivalentClasses = null;
    // Map property uri to ValueRestriction
    private transient Map<String,EIValueRestriction> mapValueRestrictions = null;
    // Set of values of the class group annotation.
    // May eventually expand this data structure to support more annotation
    // predicates as needed.
    // This could be pushed down to EIOntResource, but I wanted it
    // transient (pulled to the client on demand) for EIClass
    // and non-transient for EIProperty
    private transient Set<String> setAnnotationValueURI = null;
    
    public static EIClass NULL_CLASS = new EIClass(EIEntity.NULL_ENTITY, false, false, false, false, false, true);

    private EIClass() {
        // for GWT
    }

    public EIClass(EIEntity entity, boolean isInferred, boolean hasProperty, boolean hasSubClass, boolean hasSuperClass, boolean hasEquivalentClass, boolean isEagleIResource) {
        super(entity);
        this.isInferred = isInferred;
        this.hasProperty = hasProperty;
        this.hasSubClass = hasSubClass;
        this.hasSuperClass = hasSuperClass;
        this.hasEquivalentClass = hasEquivalentClass;
        this.isEagleIResource = isEagleIResource;
    }
    
    public boolean isInferred() {
    	return this.isInferred;
    }

    /**
     * Returns true if this class is an eagle-i class 
     * (a top-level resource class or a subclass of a top-level class).
     * Returns false if this class is not an eagle-i resource
     * class.
     *  
     * @return
     */
    public boolean isEagleIResource() {
        return isEagleIResource;
    }
    
    public boolean hasProperty() {
        return hasProperty;
    }

    public boolean hasSubClass() {
        return hasSubClass;
    }

    /**
     * Indicates whether this class has a superclass.
     * The "top-level" resource classes are defined as having a
     * no superclass.
     * 
     * @return
     */
    public boolean hasSuperClass() {
        return hasSuperClass;
    }

    /**
     * Gets the superclass of this class. This value is lazily populated
     * and will be null until setSuperClass() has been called.  If this
     * is a "top-level" resource class, it will always have a null superclass.
     * Calling this method does not set the value.
     * 
     * @return null if hasSuperClass() is false or if the superclass has not been
     *         set yet.
     */
    public EIClass getSuperClass() {
        return superclass;
    }

    public void setSuperClass(EIClass superclass) {
        this.superclass = superclass;
    }

    /**
     * Gets the list of superclasses of this class. This value is lazily populated
     * and will be null until setSuperClasses() has been called.  If this
     * is a "top-level" resource class, it will always have a null superclass list.
     * Calling this method does not set the value.
     * 
     * @return null if hasSuperClass() is false or if the superclasses have not been
     *         set yet.
     */
    public List<EIClass> getSuperClasses() {
        return superclasses;
    }

    public void setSuperClasses(List<EIClass> superclasses) {
        this.superclasses = superclasses;
    }

    /**
     * Gets the subclasses of this class. The subclass list is lazily populated
     * and will be null until setSubClasses() has been called. This method does
     * not populate the list.
     * 
     * @return null if hasSubClass is false or if the subclass list has not been
     *         set yet.
     */
    public List<EIClass> getSubClasses() {
        return subclasses;
    }

    public void setSubClasses(List<EIClass> subclasses) {
        this.subclasses = subclasses;
    }

    /**
     * Gets the properties of this class. The properties list is lazily
     * populated and will be null until setProperties() has been called. This
     * method does not populate the list.
     * 
     * @return null if hasProperties is false or if the properties list has not
     *         been set yet.
     */
    public List<EIProperty> getProperties() {
        return properties;
    }

    public void setProperties(List<EIProperty> properties) {
        this.properties = properties;
    }

    /**
     * Is there an EIEquivalentClass for this class.
     * 
     * @return
     */
    public boolean hasEquivalentClass() {
        return hasEquivalentClass;
    }

    /**
     * Gets the equivalent classes of this class. The equivalent class list is lazily
     * populated and will be null until setEquivalentClasses() has been called. This
     * method does not populate the list.
     * 
     * @return null if hasEquivalentClass is false or if the equivalent class list has not
     *         been set yet.
     */
    public List<EIEquivalentClass> getEquivalentClasses() {
        return equivalentClasses;
    }

    public void setEquivalentClasses(List<EIEquivalentClass> equivalentClasses) {
        this.equivalentClasses = equivalentClasses;
    }
    
    public Map<String,EIValueRestriction> getValueRestrictionMap() {
    	return this.mapValueRestrictions;
    }
    
    public void setValueRestrictionMap(Map<String,EIValueRestriction> mapValueRestrictions) {
    	this.mapValueRestrictions = mapValueRestrictions;
    }

    public Set<String> getAnnotations() {
        return setAnnotationValueURI;
    }

    public void setAnnotations(Set<String> setAnnotationValueURI) {
        this.setAnnotationValueURI = setAnnotationValueURI;
    }

}
