/**
 * The eagle-i consortium
 * Harvard University
 * Jan 7, 2011
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class NonOntologyProperties implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final EIEntity WFStateEntity = EIEntity.create( EIURI.create( "http://eagle-i.org/ont/repo/1.0/hasWorkflowState" ), "Workflow state" );
	private static final EIEntity WFOwnerEntity = EIEntity.create( EIURI.create( "http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner" ), "Workflow owner" );
	private static final EIEntity CreatedEntity = EIEntity.create( EIURI.create( "http://purl.org/dc/terms/created" ), "Creation date" );
	private static final EIEntity ModifiedEntity = EIEntity.create( EIURI.create( "http://purl.org/dc/terms/modified" ), "Last modification date" );
	private static final EIEntity stubEntity = EIEntity.create("http://eagle-i.org/ont/datatools/1.0/is_stub", "");
	private Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIEntity>>();
	private Map<EIEntity, Set<String>> nonOntologyLiteralProperties = new HashMap<EIEntity, Set<String>>();
	private Map<EIEntity, EIEntity> readOnlyResourceProperties;
	private Map<EIEntity, String> readOnlyLiteralProperties;
	
	NonOntologyProperties() {
		//For GWT
	}
	
	public String getStubPropertyValue() {
		Set<String> values = nonOntologyLiteralProperties.get( stubEntity );
		if(values == null || values.isEmpty()) {
			return null;
		} else {
			return values.iterator().next();
		}
	}
	
	//FIXME return EIEntity.NULL_ENTITY

	public EIEntity getWFState() {
		if ( readOnlyResourceProperties == null ) {
			return null;
		}
		if ( readOnlyResourceProperties.containsKey( WFStateEntity ) ) {
			return readOnlyResourceProperties.get( WFStateEntity );
		} else {
			return null;
		}
	}

	public void setWFState(final EIEntity state) {
		setReadOnlyResourceProperty( WFStateEntity, state );
	}

	public EIEntity getWFOwner() {
		if ( readOnlyResourceProperties == null ) {
			return null;
		}
		if ( readOnlyResourceProperties.containsKey( WFOwnerEntity ) ) {
			return readOnlyResourceProperties.get( WFOwnerEntity );
		} else {
			return null;
		}
	}

	public void setWFOwner(final EIEntity ownerUri) {
		setReadOnlyResourceProperty( WFOwnerEntity, ownerUri );
	}

	public String getCreationDate() {
		if ( readOnlyLiteralProperties == null ) {
			return null;
		}
		if ( readOnlyLiteralProperties.containsKey( CreatedEntity ) ) {
			return readOnlyLiteralProperties.get( CreatedEntity );
		} else {
			return null;
		}
	}

	public void setCreationDate(final String date) {
		setReadOnlyLiteralProperty( CreatedEntity, date );
	}

	public String getModificationDate() {
		if ( readOnlyLiteralProperties == null ) {
			return null;
		}
		if ( readOnlyLiteralProperties.containsKey( ModifiedEntity ) ) {
			return readOnlyLiteralProperties.get( ModifiedEntity );
		} else {
			return null;
		}
	}

	public void setModificationDate(final String date) {
		setReadOnlyLiteralProperty( ModifiedEntity, date );
	}

	public Map<EIEntity, Set<EIEntity>> getNonOntologyResourceProperties() {
		return nonOntologyResourceProperties;
	}

	public void addNonOntologyResourceProperty(final EIEntity property, final EIEntity resource) {
		Set<EIEntity> pValues;
		pValues = nonOntologyResourceProperties.get( property );
		if ( pValues == null ) {
			pValues = new HashSet<EIEntity>();
			nonOntologyResourceProperties.put( property, pValues );
		}
		pValues.add( resource );
	}

	public Set<EIEntity> getNonOntologyResourceProperty(final EIEntity property) {
		return nonOntologyResourceProperties.get( property );
	}

	public void replaceNonOntologyResourcePropertyValue(final EIEntity property, final EIURI oldValue, final EIEntity newValue) {
		Set<EIEntity> pValues;
		pValues = nonOntologyResourceProperties.get( property );
		if ( pValues == null ) {
			pValues = new HashSet<EIEntity>();
			nonOntologyResourceProperties.put( property, pValues );
		}
		pValues.remove( EIEntity.create( oldValue, "" ) );
		if ( newValue != null && newValue != EIEntity.NULL_ENTITY ) {
			pValues.add( newValue );
		}
	}

	public void replaceNonOntologyResourcePropertyAllValues(final EIEntity property, final Set<EIEntity> values) {
		nonOntologyResourceProperties.put( property, values );
	}

	public Map<EIEntity, Set<String>> getNonOntologyLiteralProperties() {
		return nonOntologyLiteralProperties;
	}

	public void addNonOntologyLiteralProperty(final EIEntity property, final String literal) {
		Set<String> pValues = nonOntologyLiteralProperties.get( property );
		if ( pValues == null ) {
			pValues = new HashSet<String>();
			nonOntologyLiteralProperties.put( property, pValues );
		}
		pValues.add( literal );
	}

	public Set<String> getNonOntologyLiteralProperty(final EIEntity property) {
		return nonOntologyLiteralProperties.get( property );
	}

	public void replaceNonOntologyLiteralProperty(final EIEntity property, final String oldValue, final String newValue) {
		Set<String> pValues = nonOntologyLiteralProperties.get( property );
		if ( pValues == null ) {
			pValues = new HashSet<String>();
			nonOntologyLiteralProperties.put( property, pValues );
		}
		pValues.remove( oldValue );
		if ( newValue != null && !newValue.equals( "" ) ) {
			pValues.add( newValue );
		}
	}

	public void replaceNonOntologyLiteralPropertyAllValues(final EIEntity property, final Set<String> values) {
		nonOntologyLiteralProperties.put( property, values );
	}

	public Map<EIEntity, EIEntity> getReadOnlyResourceProperties() {
		if ( readOnlyResourceProperties == null ) {
			return Collections.emptyMap();
		} else {
			return readOnlyResourceProperties;
		}
	}

	public void setReadOnlyResourceProperty(final EIEntity property, final EIEntity value) {
		if ( readOnlyResourceProperties == null ) {
			readOnlyResourceProperties = new HashMap<EIEntity, EIEntity>();
		}
		readOnlyResourceProperties.put( property, value );
	}

	public Map<EIEntity, String> getReadOnlyLiteralProperties() {
		if ( readOnlyLiteralProperties == null ) {
			return Collections.emptyMap();
		} else {
			return readOnlyLiteralProperties;
		}
	}

	public void setReadOnlyLiteralProperties(final Map<EIEntity, String> readOnlyLiteralProperties) {
		this.readOnlyLiteralProperties = readOnlyLiteralProperties;
	}

	public void setReadOnlyLiteralProperty(final EIEntity property, final String value) {
		if ( readOnlyLiteralProperties == null ) {
			readOnlyLiteralProperties = new HashMap<EIEntity, String>();
		}
		readOnlyLiteralProperties.put( property, value );
	}

}
