package org.eaglei.model;

import java.util.Map;
import java.util.Set;

public class SearchEIInstancePreview {
	private int propertyCount;
	private final EIInstance actualInstance;
	
	public SearchEIInstancePreview(final EIInstance basicInstance) {
		actualInstance = basicInstance;
		
		propertyCount = 0;
		countProperties( basicInstance );
	}

	private void countProperties(final EIInstance basicInstance) {
		Map<EIEntity, Set<String>> datatypeProps = basicInstance.getDatatypeProperties();
		for ( EIEntity key : datatypeProps.keySet() ) {
			propertyCount += datatypeProps.get( key ).size();
		}
		
		Map<EIEntity, Set<EIEntity>> objectProps = basicInstance.getObjectProperties();
		for ( EIEntity key : objectProps.keySet() ) {
			propertyCount += objectProps.get( key ).size();
		}
	}

	public EIEntity getEntity() {
		return actualInstance.getEntity();
	}

	public int getPropertyCount() {
		return propertyCount;
	}
	
	public EIURI getInstanceURI() {
		return actualInstance.getInstanceURI();
	}

	public String getInstanceLabel() {
		return actualInstance.getInstanceLabel();
	}

	public EIEntity getInstanceType() {
		return actualInstance.getInstanceType();
	}

	public EIInstance getRealInstance() {
		return actualInstance;
	}
}
