package org.eaglei.model;

import java.io.Serializable;

/**
 * A class that associates a label string with a URI.
 */
public class EIEntity implements Serializable, Comparable<EIEntity> {

    public static final long serialVersionUID = 1L;

    public static final String NO_LABEL = "<none>";
    public static final EIEntity NULL_ENTITY = EIEntity.create(EIURI.NULL_EIURI, NO_LABEL);
    
    private EIURI uri;
    private String label;

    public void setLabel(String label) {
		this.label = label;
	}

	/*
     * Disallow use of no-arg constructor
     */
    private EIEntity() {
        // For GWT
    }

    private EIEntity(EIURI uri, String label) {
        assert (uri != null) : "URI must be non-null: uri ["+uri+"] label ["+label+"]";
        this.uri = uri;
        // Note: do not change this behavior without updating the
        // ontology acceptance tests which currently check for 
        // any occurances of NO_LABEL.
        if (label != null) {
            this.label = label;
        } else {
            this.label = NO_LABEL;
        }
    }

    public static EIEntity create(String strURI, String label) {
        return new EIEntity(EIURI.create(strURI), label);
    }

    public static EIEntity create(EIURI uri, String label) {
        // Can add intern'ing
        return new EIEntity(uri, label);
    }

    public EIURI getURI() {
        return uri;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof EIEntity) {
            EIEntity other = (EIEntity) o;
            return other.getURI().equals(getURI());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return uri.hashCode();
    }

    @Override
    public String toString() {
        return label + " : " + uri.toString();
    }

    @Override
    public int compareTo(EIEntity o) {
        int c = getLabel().toLowerCase().compareTo(o.getLabel().toLowerCase());
        if (c == 0) {
            return getURI().toString().compareTo(o.getURI().toString());
        } else {
            return c;
        }
    }   

}
