package org.eaglei.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public abstract class EIProperty extends EIOntResource implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private EIValueRestriction valueRestriction;
    // Set of values of the property group annotation.
    // May eventually expand this data structure to support more annotation
    // predicates as needed.
    // This could be pushed down to EIOntResource, but I wanted it
    // transient (pulled to the client on demand) for EIClass
    // and non-transient for EIProperty
    private Set<String> setAnnotationValueURI = null;

    protected EIProperty() {
        // gwt
    }

    public EIProperty(EIEntity entity) {
        super(entity);
    }

	public EIValueRestriction getValueRestriction() {
		return valueRestriction;
	}

	public void setValueRestriction(EIValueRestriction valueRestriction) {
		this.valueRestriction = valueRestriction;
	}

    public Set<String> getAnnotations() {
        return setAnnotationValueURI;
    }

    public void setAnnotations(Set<String> setAnnotationValueURI) {
        this.setAnnotationValueURI = setAnnotationValueURI;
    }

}
